/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.dispatching.teditor.validation;

import activity.Activity;
import activity.Claim;
import activity.LocationPrerequisite;
import activity.Move;
import activity.util.EventSequenceValidator;
import com.google.common.collect.Iterables;
import dispatching.ActivityDispatching;
import dispatching.Attribute;
import dispatching.Dispatch;
import dispatching.DispatchGroup;
import dispatching.DispatchingPackage;
import dispatching.impl.AttributesMapEntryImpl;
import dispatching.util.DispatchingUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import machine.IResource;
import machine.Import;
import machine.MachinePackage;
import machine.Peripheral;
import machine.Resource;
import machine.ResourceItem;
import machine.SymbolicPosition;
import machine.util.ResourcePeripheralKey;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.graph.directed.editable.EdgQueries;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.lsat.dispatching.teditor.validation.AbstractDispatchingValidator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class DispatchingValidator
extends AbstractDispatchingValidator {
    public static final String GREATER_OFFSET = "greaterOffset";
    public static final String INVALID_IMPORT = "invalidImport";
    public static final String REMOVE_ITEM = "removeItem";
    public static final String SELECT_ITEM_FOR_RESOURCE = "selectItemForResource";
    public static final String REPLACE_ITEM_FOR_RESOURCE = "replaceItemForResource";
    public static final String CONVERT_YIELD = "convertYield";

    @Check
    public void checkObsoleteThroughput(ActivityDispatching ad) {
        boolean _eIsSet = ad.eIsSet((EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__NUMBER_OF_ITERATIONS);
        if (_eIsSet) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Througput is obsolete. Specify yield below in activities");
            this.warning(_builder.toString(), (EObject)ad, (EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__NUMBER_OF_ITERATIONS, CONVERT_YIELD, new String[0]);
        }
        int i = 0;
        while (i < ad.getResourceIterations().size()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Througput is obsolete. Specify yield below in activities");
            this.warning(_builder_1.toString(), (EObject)ad, (EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__RESOURCE_ITERATIONS, i, CONVERT_YIELD, new String[0]);
            ++i;
        }
    }

    @Check
    public void checkDuplicateDispatchGroup(ActivityDispatching ad) {
        Functions.Function1 _function = it -> it.eIsSet((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__NAME);
        Functions.Function1 _function_1 = it -> it.getName();
        Functions.Function1 _function_2 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<DispatchGroup> _function_3 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate dispatch group name  '");
            String _name = it.getName();
            _builder.append(_name);
            _builder.append("' Rename one");
            this.error(_builder.toString(), (EObject)ad, (EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__DISPATCH_GROUPS, ad.getDispatchGroups().indexOf(it));
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)IterableExtensions.filter((Iterable)ad.getDispatchGroups(), (Functions.Function1)_function), (Functions.Function1)_function_1).values(), (Functions.Function1)_function_2)).forEach(_function_3);
    }

    @Check
    public void checkImportIsValid(Import imp) {
        try {
            boolean isUnderstood;
            boolean isImportUriValid = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
            if (!isImportUriValid) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The import ");
                String _importURI = imp.getImportURI();
                _builder.append(_importURI);
                _builder.append(" cannot be resolved. Make sure that the name is spelled correctly.");
                this.error(_builder.toString(), (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            if (!(isUnderstood = imp.getImportURI().matches(".*\\.(activity)"))) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Importing ");
                String _importURI_1 = imp.getImportURI();
                _builder_1.append(_importURI_1);
                _builder_1.append(" is not allowed. Only 'activity' files are allowed");
                this.error(_builder_1.toString(), (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("The import ");
                String _importURI_2 = imp.getImportURI();
                _builder_2.append(_importURI_2);
                _builder_2.append(" is not a valid URI.");
                this.error(_builder_2.toString(), (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Check
    public void checkOffsetShouldBeGreaterThanPrevious(ActivityDispatching activityDispatching) {
        EList dispatchGroups = activityDispatching.getDispatchGroups();
        int i = 1;
        while (i < dispatchGroups.size()) {
            BigDecimal _offset_1;
            boolean _lessThan;
            BigDecimal _offset = ((DispatchGroup)dispatchGroups.get(i)).getOffset();
            boolean bl = _lessThan = _offset.compareTo(_offset_1 = ((DispatchGroup)dispatchGroups.get(i - 1)).getOffset()) < 0;
            if (_lessThan) {
                this.error("Offset should be greater then previously defined offset", (EObject)dispatchGroups.get(i), (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__OFFSET, GREATER_OFFSET, new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void checkResourceItemsDuplicate(Dispatch dis) {
        Functions.Function1 _function = it -> it.getResource();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<ResourceItem> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate item specified for Resource '");
            String _fqn = it.getResource().fqn();
            _builder.append(_fqn);
            _builder.append("' Remove one");
            this.error(_builder.toString(), (EObject)dis, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__RESOURCE_ITEMS, dis.getResourceItems().indexOf(it), REMOVE_ITEM, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)dis.getResourceItems(), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkMissingResourceItem(Dispatch dis) {
        EList<Resource> resourcesNeedingItem = this.getResourcesNeedingItem(dis);
        EcoreUtil.resolveAll((EObject)dis.eContainer());
        Functions.Function1 _function = it -> it.getResource();
        resourcesNeedingItem.removeAll((Collection)ListExtensions.map((List)dis.getResourceItems(), (Functions.Function1)_function));
        Consumer<Resource> _function_1 = res -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No item specified for Resource '");
            String _fqn = res.fqn();
            _builder.append(_fqn);
            _builder.append("' Press <ctrl> spacebar");
            this.error(_builder.toString(), (EObject)dis, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__RESOURCE_ITEMS);
        };
        resourcesNeedingItem.forEach(_function_1);
    }

    @Check
    public void checkResourceItemNeedsResource(Dispatch dis) {
        Procedures.Procedure2 _function = (item, index) -> {
            boolean _greaterEqualsThan;
            int _size = this.getResourcesNeedingItem(dis).size();
            boolean bl = _greaterEqualsThan = index >= _size;
            if (_greaterEqualsThan) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Unnecessary item specified  '");
                String _fqn = item.fqn();
                _builder.append(_fqn);
                _builder.append("' ");
                this.error(_builder.toString(), (EObject)dis, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__RESOURCE_ITEMS, (int)index, REMOVE_ITEM, new String[0]);
            }
        };
        IterableExtensions.forEach((Iterable)dis.getResourceItems(), (Procedures.Procedure2)_function);
    }

    @Check
    public void validateAttributesDuplicate(Dispatch dis) {
        Functions.Function1 _function = it -> ((Attribute)it.getKey()).getName();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Map.Entry> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate item specified for Attribute '");
            String _name = ((Attribute)it.getKey()).getName();
            _builder.append(_name);
            _builder.append("' Remove one");
            this.error(_builder.toString(), (EObject)dis, (EStructuralFeature)DispatchingPackage.Literals.HAS_USER_ATTRIBUTES__USER_ATTRIBUTES, dis.getUserAttributes().indexOf(it), REMOVE_ITEM, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)dis.getUserAttributes(), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void validateAttributeValue(AttributesMapEntryImpl entry) {
        boolean _not;
        boolean _tripleEquals;
        String _value = entry.getValue();
        boolean bl = _tripleEquals = _value == null;
        if (_tripleEquals) {
            return;
        }
        String illegalChars = entry.getValue().replaceAll("[\\w\\.\\-\\s]", "");
        boolean _isEmpty = illegalChars.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            Dispatch parent = (Dispatch)EcoreUtil2.getContainerOfType((EObject)entry, Dispatch.class);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Attribute value may not contain  '");
            _builder.append(illegalChars);
            _builder.append("'. only 'a-zA-Z0-9-_.<space><tab>' are allowed ");
            this.error(_builder.toString(), (EObject)parent, (EStructuralFeature)DispatchingPackage.Literals.HAS_USER_ATTRIBUTES__USER_ATTRIBUTES, parent.getUserAttributes().indexOf((Object)entry), REMOVE_ITEM, new String[0]);
        }
    }

    @Check
    public void validatePosition(ActivityDispatching activityDispatching) {
        LinkedHashMap positionState = CollectionLiterals.newLinkedHashMap();
        Consumer<DispatchGroup> _function = dispatchGroup -> {
            Procedures.Procedure2 _function_1 = (disp, index) -> {
                Activity activity = disp.getActivity();
                LinkedHashMap<ResourcePeripheralKey, SymbolicPosition> locationPrerequisites = this.indexPrerequisites((Dispatch)disp, (int)index);
                Set<Map.Entry<ResourcePeripheralKey, SymbolicPosition>> _entrySet = locationPrerequisites.entrySet();
                for (Map.Entry<ResourcePeripheralKey, SymbolicPosition> prerequisite : _entrySet) {
                    SymbolicPosition _value;
                    PositionInfo _positionInfo;
                    ResourcePeripheralKey _key = prerequisite.getKey();
                    PositionInfo positionInfo = positionState.put(_key, _positionInfo = new PositionInfo(_value = prerequisite.getValue(), activity));
                    if (positionInfo == null || positionInfo.position.equals(prerequisite.getValue())) continue;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Activity ");
                    String _name = activity.getName();
                    _builder.append(_name);
                    _builder.append(" requires peripheral ");
                    String _fqn = prerequisite.getKey().fqn();
                    _builder.append(_fqn);
                    _builder.append(" at position ");
                    String _name_1 = prerequisite.getValue().getName();
                    _builder.append(_name_1);
                    _builder.append(", but activity ");
                    String _name_2 = positionInfo.activity.getName();
                    _builder.append(_name_2);
                    _builder.append(" leaves it at position ");
                    String _name_3 = positionInfo.position.getName();
                    _builder.append(_name_3);
                    this.warning(_builder.toString(), (EObject)disp, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__ACTIVITY);
                }
                EList topologicalOrder = EdgQueries.topologicalOrdering((Iterable)activity.getNodes());
                if (topologicalOrder == null) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Location prerequisites cannot be validated for the next activity as activity ");
                    String _name = activity.getName();
                    _builder.append(_name);
                    _builder.append(" contains a cycle");
                    this.error(_builder.toString(), (EObject)disp, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__ACTIVITY);
                    positionState.clear();
                } else {
                    Functions.Function1 _function_2 = it -> it.isPositionMove();
                    Iterable _filter = IterableExtensions.filter((Iterable)QueryableIterable.from((Iterable)topologicalOrder).objectsOfKind(Move.class), (Functions.Function1)_function_2);
                    for (Move move : _filter) {
                        IResource _actualResource = DispatchingValidator.getActualResource(disp, move.getResource());
                        Peripheral _peripheral = move.getPeripheral();
                        ResourcePeripheralKey _resourcePeripheralKey = new ResourcePeripheralKey(_actualResource, _peripheral);
                        SymbolicPosition _targetPosition = move.getTargetPosition();
                        PositionInfo _positionInfo = new PositionInfo(_targetPosition, activity);
                        positionState.put(_resourcePeripheralKey, _positionInfo);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)dispatchGroup.getDispatches(), (Procedures.Procedure2)_function_1);
        };
        activityDispatching.getDispatchGroups().forEach(_function);
    }

    @Check
    public void checkUnfolded(final ActivityDispatching activityDispatching) {
        final List<Dispatch> unfoldedDispatches = DispatchingValidator.unfoldedDispatches(activityDispatching);
        EventSequenceValidator.ErrorRaiser errorRaiser = new EventSequenceValidator.ErrorRaiser(){

            public void raise(int listIndex, String msg) {
                if (listIndex < 0) {
                    DispatchingValidator.this.error(msg, (EObject)activityDispatching, (EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__DISPATCH_GROUPS);
                } else {
                    Dispatch d = (Dispatch)unfoldedDispatches.get(listIndex);
                    EObject _eContainer = d.eContainer();
                    DispatchGroup dg = (DispatchGroup)_eContainer;
                    DispatchingValidator.this.error(msg, (EObject)dg, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__DISPATCHES, dg.getDispatches().indexOf((Object)d));
                }
            }
        };
        Functions.Function1 _function = it -> it.getActivity();
        EventSequenceValidator.validate((List)IterableExtensions.toList((Iterable)ListExtensions.map(unfoldedDispatches, (Functions.Function1)_function)), (EventSequenceValidator.ErrorRaiser)errorRaiser);
        Functions.Function1 _function_1 = d -> {
            Functions.Function1 _function_2 = c -> Pair.of((Object)c, (Object)d);
            return IterableExtensions.map((Iterable)Iterables.filter((Iterable)d.getActivity().getNodes(), Claim.class), (Functions.Function1)_function_2);
        };
        Iterable claimsWithDispatches = IterableExtensions.flatMap(unfoldedDispatches, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> ((Claim)it.getKey()).getResource();
        Functions.Function1 _function_3 = claims -> {
            Functions.Function2 _function_4 = (p1, p2) -> {
                boolean _isPassive_1;
                boolean _isPassive = ((Claim)p1.getKey()).isPassive();
                return _isPassive == (_isPassive_1 = ((Claim)p2.getKey()).isPassive());
            };
            Functions.Function1 _function_5 = it -> ((Claim)((Pair)IterableExtensions.head((Iterable)it)).getKey()).isPassive();
            Iterable passiveClaimsGroups = IterableExtensions.filter((Iterable)Queries.segment((Iterable)claims, (Functions.Function2)_function_4), (Functions.Function1)_function_5);
            Functions.Function1 _function_6 = passiveClaims -> {
                Functions.Function1 _function_7 = it -> ((Dispatch)it.getValue()).getActivity();
                Functions.Function1 _function_8 = it -> {
                    int _size = it.size();
                    return _size > 1;
                };
                Iterable duplicatePassiveClaims = Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)passiveClaims, (Functions.Function1)_function_7).values(), (Functions.Function1)_function_8));
                Functions.Function1 _function_9 = it -> (Dispatch)it.getValue();
                return IterableExtensions.map((Iterable)duplicatePassiveClaims, (Functions.Function1)_function_9);
            };
            return IterableExtensions.flatMap((Iterable)passiveClaimsGroups, (Functions.Function1)_function_6);
        };
        Iterable duplicatePassiveClaimDispatches = IterableExtensions.flatMap(IterableExtensions.groupBy((Iterable)claimsWithDispatches, (Functions.Function1)_function_2).values(), (Functions.Function1)_function_3);
        Consumer<Dispatch> _function_4 = dispatch -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Activity ");
            String _name = dispatch.getActivity().getName();
            _builder.append(_name);
            _builder.append(" cannot be repeated within a passive claim sequence.");
            this.error(_builder.toString(), (EObject)dispatch, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__ACTIVITY);
        };
        Queries.unique((Iterable)duplicatePassiveClaimDispatches).forEach(_function_4);
    }

    private static List<Dispatch> unfoldedDispatches(ActivityDispatching activityDispatching) {
        ArrayList unfoldedDispatches = CollectionLiterals.newArrayList();
        Consumer<DispatchGroup> _function = dg -> {
            int _numberRepeats = DispatchingUtil.getNumberRepeats((DispatchGroup)dg);
            IntegerRange _upTo = new IntegerRange(1, _numberRepeats);
            for (Integer i : _upTo) {
                unfoldedDispatches.addAll(dg.getDispatches());
            }
        };
        activityDispatching.getDispatchGroups().forEach(_function);
        return unfoldedDispatches;
    }

    @Check
    public void validateRepeatAndOffset(DispatchGroup group) {
        if (BigDecimal.ZERO.compareTo(group.getOffset()) != 0 && DispatchingUtil.getNumberRepeats((DispatchGroup)group) > 1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("offset must be ommited or zero when repeats are specified");
            String msg = _builder.toString();
            this.error(msg, (EObject)group, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__OFFSET);
            this.error(msg, (EObject)group, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__REPEATS, 0);
        }
    }

    @Check
    public void validatePhase(AttributesMapEntryImpl entry) {
        boolean _equalsIgnoreCase_1;
        boolean _not;
        boolean _equalsIgnoreCase;
        DispatchGroup dispatchGroup = (DispatchGroup)EcoreUtil2.getContainerOfType((EObject)entry, DispatchGroup.class);
        if (dispatchGroup == null) {
            return;
        }
        boolean _and = false;
        Attribute _key = entry.getKey();
        String _name = null;
        if (_key != null) {
            _name = _key.getName();
        }
        if (_and = !(_equalsIgnoreCase = "phase".equalsIgnoreCase(_name)) ? false : (_not = !(_equalsIgnoreCase_1 = dispatchGroup.getName().equalsIgnoreCase(entry.getValue())))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("phase is a reserved attribute and may not be used");
            String msg = _builder.toString();
            this.error(msg, (EObject)entry, (EStructuralFeature)DispatchingPackage.Literals.ATTRIBUTES_MAP_ENTRY__KEY);
        }
    }

    @Check
    public void validateIteratorName(AttributesMapEntryImpl entry) {
        int _numberRepeats;
        boolean _greaterThan;
        boolean _equalsIgnoreCase;
        DispatchGroup dispatchGroup = (DispatchGroup)EcoreUtil2.getContainerOfType((EObject)entry, DispatchGroup.class);
        if (dispatchGroup == null) {
            return;
        }
        boolean _and = false;
        String _iteratorName = dispatchGroup.getIteratorName();
        Attribute _key = entry.getKey();
        String _name = null;
        if (_key != null) {
            _name = _key.getName();
        }
        if (_and = !(_equalsIgnoreCase = _iteratorName.equalsIgnoreCase(_name)) ? false : (_greaterThan = (_numberRepeats = DispatchingUtil.getNumberRepeats((DispatchGroup)dispatchGroup)) > 1)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("attribute key may not be equal to activites iterator name. Change key or iterator name ");
            String msg = _builder.toString();
            this.error(msg, (EObject)entry, (EStructuralFeature)DispatchingPackage.Literals.ATTRIBUTES_MAP_ENTRY__KEY);
            boolean _eIsSet = dispatchGroup.eIsSet((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__ITERATOR_NAME);
            if (_eIsSet) {
                this.error(msg, (EObject)dispatchGroup, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__ITERATOR_NAME);
            }
        }
    }

    public EList<Resource> getResourcesNeedingItem(Dispatch dis) {
        return dis.getActivity().getResourcesNeedingItem();
    }

    private LinkedHashMap<ResourcePeripheralKey, SymbolicPosition> indexPrerequisites(Dispatch disp, int index) {
        EList prerequisites = disp.getActivity().getPrerequisites();
        LinkedHashMap result = CollectionLiterals.newLinkedHashMap();
        for (LocationPrerequisite prerequisite : prerequisites) {
            Peripheral _peripheral;
            IResource _actualResource = DispatchingValidator.getActualResource(disp, prerequisite.getResource());
            ResourcePeripheralKey key = new ResourcePeripheralKey(_actualResource, _peripheral = prerequisite.getPeripheral());
            boolean _containsKey = result.containsKey(key);
            if (_containsKey) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Only one location prerequisite per peripheral is allowed");
                this.error(_builder.toString(), (EObject)disp, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__ACTIVITY);
            }
            result.put(key, prerequisite.getPosition());
        }
        return result;
    }

    private static IResource getActualResource(Dispatch dispatch, IResource resource) {
        Functions.Function1 _function = it -> {
            Resource _resource = it.getResource();
            return _resource == resource;
        };
        IResource result = (IResource)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)dispatch.getResourceItems(), IResource.class), (Functions.Function1)_function);
        IResource _xifexpression = null;
        _xifexpression = result == null ? resource : result;
        return _xifexpression;
    }

    private static final class PositionInfo {
        private final SymbolicPosition position;
        private final Activity activity;

        PositionInfo(SymbolicPosition position, Activity activity) {
            this.position = position;
            this.activity = activity;
        }
    }
}

