/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.lsat.common.util.StackedIterator;

public class BufferedIterator<E>
extends StackedIterator<E> {
    private LinkedList<E> record = null;

    public BufferedIterator(Iterator<? extends E> source) {
        super(source);
    }

    @Override
    public E next() {
        Object next = super.next();
        if (this.record != null) {
            this.record.add(next);
        }
        return next;
    }

    public void mark() {
        this.record = new LinkedList();
    }

    public void unmark() {
        this.record = null;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean unmark) {
        if (this.record == null) {
            throw new IllegalStateException("Iterator has not been marked yet!");
        }
        this.push(this.record.iterator());
        this.record = unmark ? null : new LinkedList();
    }

    public E current() {
        if (this.record == null) {
            throw new IllegalStateException("Iterator has not been marked yet!");
        }
        return this.record.peekLast();
    }
}

