/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.automaton;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.algorithms.Tarjan;
import org.eclipse.lsat.common.ludus.backend.automaton.MPAState;
import org.eclipse.lsat.common.ludus.backend.automaton.MPATransition;
import org.eclipse.lsat.common.ludus.backend.automaton.MaxPlusAutomaton;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;

public class ComputeMPA {
    private static final Value DEFAULT_REWARD = new Value(1.0);

    private ComputeMPA() {
    }

    public static <V, E> MaxPlusAutomaton<V> computeMaxPlusAutomaton(FSM<V, E> fsm, Integer vectorSize, Map<String, Matrix> matrices) {
        return ComputeMPA.computeMaxPlusAutomaton(fsm, vectorSize, matrices, new HashMap<String, Value>());
    }

    public static <V, E> MaxPlusAutomaton<V> computeMaxPlusAutomaton(FSM<V, E> fsm, Integer vectorSize, Map<String, Matrix> matrices, Map<String, Value> rewardMap) {
        MaxPlusAutomaton<Object> mpa = new MaxPlusAutomaton<Object>();
        for (Object v : fsm.getVertices()) {
            int index = 0;
            while (index < vectorSize) {
                mpa.addState(new MPAState(v, index));
                ++index;
            }
        }
        for (Object e : fsm.getEdges()) {
            String event = fsm.getEvent(e);
            Matrix m = matrices.get(event);
            int row = 0;
            while (row < m.getRows()) {
                int col = 0;
                while (col < m.getColumns()) {
                    Value reward = rewardMap.getOrDefault(event, DEFAULT_REWARD);
                    Value duration = m.get(row, col);
                    MPAState source = mpa.getState(fsm.getEdgeSource(e), row);
                    MPAState target = mpa.getState(fsm.getEdgeTarget(e), col);
                    if (!duration.equals(Value.NEGATIVE_INFINITY)) {
                        mpa.addTransition(new MPATransition(source, event, reward, duration, target));
                    }
                    ++col;
                }
                ++row;
            }
        }
        return mpa;
    }

    public static <T> MaxPlusAutomaton<T> swapWeights(MaxPlusAutomaton<T> automaton) {
        HashMap<MPAState<T>, MPAState<T>> mapping = new HashMap<MPAState<T>, MPAState<T>>();
        MaxPlusAutomaton mpa = new MaxPlusAutomaton();
        for (MPAState<T> s : automaton.getVertices()) {
            MPAState<T> s_new = new MPAState<T>(s.getLocation(), s.getIndex());
            mpa.addState(s_new);
            mapping.put(s, s_new);
        }
        for (MPAState<T> c : automaton.getVertices()) {
            for (MPATransition<T> t : automaton.outgoingEdgesOf(c)) {
                mpa.addTransition(new MPATransition((MPAState)mapping.get(t.getSource()), t.getEvent(), t.getDuration(), t.getReward(), (MPAState)mapping.get(t.getTarget())));
            }
        }
        return mpa;
    }

    public static <T> List<MaxPlusAutomaton<T>> getSCCs(MaxPlusAutomaton<T> automaton) {
        ArrayList<MaxPlusAutomaton<T>> sccList = new ArrayList<MaxPlusAutomaton<T>>();
        Tarjan tarjan = new Tarjan();
        List sccVerticesList = tarjan.computeSCCs(automaton);
        for (Set scc : sccVerticesList) {
            MaxPlusAutomaton<T> mpaSCC = new MaxPlusAutomaton<T>();
            for (MPAState s : scc) {
                mpaSCC.addState(s);
                for (MPATransition<T> t : automaton.outgoingEdgesOf(s)) {
                    if (!scc.contains(t.getTarget())) continue;
                    mpaSCC.addTransition(t);
                }
            }
            if (mpaSCC.getEdges().size() <= 0) continue;
            sccList.add(mpaSCC);
        }
        return sccList;
    }
}

