/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased;

import java.util.List;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.eventbased.equivalence.CounterExample;
import org.eclipse.escet.cif.eventbased.equivalence.LangEquivCalculation;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.Strings;

public class LanguageEquivalence {
    private LanguageEquivalence() {
    }

    public static void preCheck(List<Automaton> auts) {
        if (auts.size() != 2) {
            String msg = Strings.fmt((String)"Expected two automata, found %d automat%s.", (Object[])new Object[]{auts.size(), auts.size() == 1 ? "on" : "a"});
            throw new InvalidInputException(msg);
        }
        for (Automaton aut : auts) {
            if (aut.initial != null) continue;
            String msg = Strings.fmt((String)"Automaton \"%s\" has no initial location.", (Object[])new Object[]{aut.name});
            throw new InvalidInputException(msg);
        }
        if (!auts.get((int)0).alphabet.equals(auts.get((int)1).alphabet)) {
            String msg = Strings.fmt((String)"Automaton \"%s\" has a different alphabet than automaton \"%s\".", (Object[])new Object[]{auts.get((int)0).name, auts.get((int)1).name});
            throw new InvalidInputException(msg);
        }
        for (Automaton aut : auts) {
            AutomatonHelper.reportNonDeterministic(aut);
        }
    }

    public static CounterExample doLanguageEquivalenceCheck(List<Automaton> auts) {
        LangEquivCalculation lec = new LangEquivCalculation(auts);
        return lec.checkLanguageEquivalence();
    }
}

