/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.io.conv;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.trace4cps.core.io.conv.Attribute;
import org.eclipse.trace4cps.core.io.conv.AttributeUsageType;
import org.eclipse.trace4cps.core.io.conv.AttributeValueType;
import org.eclipse.trace4cps.core.io.conv.Configuration;
import org.eclipse.trace4cps.core.io.conv.Context;
import org.eclipse.trace4cps.core.io.conv.ESIFormatParser;
import org.eclipse.trace4cps.core.io.conv.ParserException;

public class ESIFormatConfigurationParser
extends ESIFormatParser {
    private static final String FORMAT_VERSION = "V0.1";
    private static final int MAX_TIMESCALESHIFT = 99;
    private static final String CONFIGURATIONFORMATVERSION_TAG = "ConfigurationFormatVersion";
    private static final String CONFIGURATIONVERSION_TAG = "ConfigurationVersion";
    private static final String CONFIGURATIONNAME_TAG = "ConfigurationName";
    private static final String TIMESCALESHIFT_TAG = "TimeScaleShift";
    private static final String TIMESCALEUNIT_TAG = "TimeScaleUnit";
    private static final String TIMEPRESENTATIONFORMAT_TAG = "TimePresentationFormat";
    private static final String TIMEDISPLAYFORMAT_TAG = "TimeDisplayFormat";
    private static final String ATTRIBUTE_TAG = "Attribute";
    private static final String CONTEXT_TAG = "Context";
    private static final String COLORDEF_TAG = "ColorDefinition";
    private static final String QUANTITY_TAG = "Quantity";
    private static final String FILTERINGVALUES_TAG = "FilteringValues";
    private static final String SCALE_CLAIMS_IN_ACTIVITY_VIEW_TAG = "ScaleClaimsActivityView";

    public Configuration parseTraceV0config(File configFile) throws IOException, ParserException {
        Configuration config = new Configuration();
        config.setConfigurationSource(configFile.getAbsolutePath());
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream in = new FileInputStream(configFile);){
            this.parse(configFile.getAbsolutePath(), in, config);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(String src, FileInputStream in, Configuration aConfig) throws IOException, ParserException {
        int n_CONFIGURATIONVERSION = 0;
        int n_CONFIGURATIONNAME = 0;
        int n_CONFIGURATIONID = 0;
        int n_TIMESCALESHIFT = 0;
        int n_TIMESCALEUNIT = 0;
        int n_TIMEDISPLAYFORMAT = 0;
        int n_SCALE_CLAIMS = 0;
        Throwable throwable = null;
        Object var12_13 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String[] tok;
            String line = null;
            int linenr = 0;
            while (n_CONFIGURATIONVERSION == 0 && (line = reader.readLine()) != null) {
                ++linenr;
                tok = line.split("\t", -1);
                if (tok.length < 2) continue;
                switch (tok[0]) {
                    case "ConfigurationFormatVersion": {
                        System.err.println("ConfigurationFormatVersion is deprecated; use ConfigurationVersion instead");
                    }
                    case "ConfigurationVersion": {
                        aConfig.setConfigurationVersion(tok[1]);
                        if (!tok[1].equalsIgnoreCase(FORMAT_VERSION)) {
                            throw new ParserException("Configuration version not supported " + tok[1], src, linenr);
                        }
                        ++n_CONFIGURATIONVERSION;
                        break;
                    }
                    default: {
                        throw new ParserException("Configuration version missing as first element", src, linenr);
                    }
                }
            }
            block54: while ((line = reader.readLine()) != null) {
                ++linenr;
                tok = line.split("\t", -1);
                if (tok.length >= 2) {
                    switch (tok[0]) {
                        case "ConfigurationName": {
                            if (n_CONFIGURATIONNAME > 0) {
                                throw new ParserException("Configuration name allready declared as " + aConfig.getConfigurationName(), src, linenr);
                            }
                            aConfig.setConfigurationName(tok[1]);
                            ++n_CONFIGURATIONNAME;
                            continue block54;
                        }
                        case "ConfigurationID": {
                            if (n_CONFIGURATIONID > 0) {
                                throw new ParserException("Configuration ID allready declared as " + aConfig.getConfigurationID(), src, linenr);
                            }
                            aConfig.setConfigurationID(tok[1]);
                            ++n_CONFIGURATIONID;
                            continue block54;
                        }
                        case "TimeScaleShift": {
                            if (n_TIMESCALESHIFT > 0) {
                                throw new ParserException("TimeScaleShift allready declared as " + aConfig.getTimeScaleShift(), src, linenr);
                            }
                            try {
                                int timeScaleShift = Integer.parseInt(tok[1]);
                                if (Math.abs(timeScaleShift) > 99) {
                                    throw new ParserException("TimeScaleShift to large " + tok[1], src, linenr);
                                }
                                aConfig.setTimeScaleShift(timeScaleShift);
                                ++n_TIMESCALESHIFT;
                                continue block54;
                            }
                            catch (NumberFormatException e) {
                                throw new ParserException("TimeScaleShift has illegal value " + tok[1], src, linenr);
                            }
                        }
                        case "TimeScaleUnit": {
                            if (n_TIMESCALEUNIT > 0) {
                                throw new ParserException("TimeScaleUnit allready declared as " + (Object)((Object)aConfig.getTimeScaleUnit()), src, linenr);
                            }
                            if (!aConfig.setTimeScaleUnit(tok[1])) {
                                throw new ParserException("TimeScaleUnit not valid: expected a java.util.concurrent.TimeUnit string " + (Object)((Object)aConfig.getTimeScaleUnit()), src, linenr);
                            }
                            ++n_TIMESCALEUNIT;
                            continue block54;
                        }
                        case "TimePresentationFormat": {
                            System.err.println("TimePresentationFormat is deprecated; use TimeDisplayFormat instead");
                        }
                        case "TimeDisplayFormat": {
                            if (n_TIMEDISPLAYFORMAT > 0) {
                                throw new ParserException("TimeDisplayFormat allready declared as " + aConfig.getTimeDisplayFormat(), src, linenr);
                            }
                            aConfig.setTimeDisplayFormat(tok[1]);
                            ++n_TIMEDISPLAYFORMAT;
                            try {
                                String.format(aConfig.getTimeDisplayFormat(), 0.0);
                                continue block54;
                            }
                            catch (Exception e) {
                                throw new ParserException("TimeDisplayFormat is illegal at: " + e.getMessage() + " in " + aConfig.getTimeDisplayFormat(), src, linenr);
                            }
                        }
                        case "ScaleClaimsActivityView": {
                            if (n_SCALE_CLAIMS > 0) {
                                throw new ParserException("ScaleClaimsActivityView allready declared as " + aConfig.getScaleClaimsInActivityViewWithResourceAmount(), src, linenr);
                            }
                            aConfig.setScaleClaimsInActivityViewWithResourceAmount(Boolean.parseBoolean(tok[1]));
                            ++n_SCALE_CLAIMS;
                            continue block54;
                        }
                        case "Attribute": {
                            int aid;
                            int index = 1;
                            try {
                                aid = Integer.parseInt(tok[index]);
                                if (aConfig.getIdAttributeMap().containsKey(aid)) {
                                    throw new ParserException("Attribute(ID) already exists " + tok[index], src, linenr);
                                }
                                Attribute attribute = new Attribute();
                                if (tok.length <= ++index) {
                                    throw new ParserException("Required Attribute name expected for Attribute id " + aid, src, linenr);
                                }
                                attribute.setAttributeName(tok[index]);
                                if (tok.length <= ++index) {
                                    throw new ParserException("Required AttributeValue type expected for Attribute id " + aid, src, linenr);
                                }
                                AttributeValueType valuetype = AttributeValueType.get(tok[index]);
                                if (valuetype == null) {
                                    throw new ParserException("Value type " + tok[index] + " is not recognized for Attribute id " + aid, src, linenr);
                                }
                                if (valuetype != AttributeValueType.STRING) {
                                    throw new ParserException("Only AttributeValue type String is supported for Attribute id " + aid, src, linenr);
                                }
                                attribute.setAttributeValueType(valuetype);
                                ++index;
                                while (true) {
                                    if (index >= tok.length) {
                                        aConfig.addAttribute(aid, attribute);
                                        continue block54;
                                    }
                                    AttributeUsageType usagetype = AttributeUsageType.get(tok[index]);
                                    if (usagetype == null) {
                                        throw new ParserException("Usage type " + tok[index] + " is not recognized for Attribute id " + aid, src, linenr);
                                    }
                                    if (!attribute.getAttributeUsages().contains((Object)usagetype)) {
                                        attribute.getAttributeUsages().add(usagetype);
                                    }
                                    ++index;
                                }
                            }
                            catch (NumberFormatException e) {
                                throw new ParserException("AttributeID has illegal value " + tok[index], src, linenr);
                            }
                        }
                        case "Context": {
                            int aid;
                            int index = 1;
                            try {
                                int cid = Integer.parseInt(tok[index]);
                                if (aConfig.getIdContextMap().containsKey(cid)) {
                                    throw new ParserException("Context(ID) already exists " + tok[index], src, linenr);
                                }
                                Context context = new Context();
                                if (tok.length <= ++index) {
                                    throw new ParserException("Required Context Name expected for Context id " + cid, src, linenr);
                                }
                                context.setContextName(tok[index]);
                                ++index;
                                while (true) {
                                    if (index >= tok.length) {
                                        aConfig.addContext(cid, context);
                                        continue block54;
                                    }
                                    try {
                                        aid = Integer.parseInt(tok[index]);
                                        if (!aConfig.getIdAttributeMap().containsKey(aid)) {
                                            throw new ParserException("Referenced Attribute(ID) does not exist " + tok[index], src, linenr);
                                        }
                                        context.getAttributes().add(aConfig.getAttribute(aid));
                                    }
                                    catch (NumberFormatException e) {
                                        throw new ParserException("Attribute reference has illegal value " + tok[index], src, linenr);
                                    }
                                    ++index;
                                }
                            }
                            catch (NumberFormatException e) {
                                throw new ParserException("ContextID has illegal value " + tok[index], src, linenr);
                            }
                        }
                        case "ColorDefinition": {
                            int index = 1;
                            if (tok.length <= index) {
                                throw new ParserException("Required ColorName expected for ColorDefinition", src, linenr);
                            }
                            String colorDefName = tok[index];
                            if (tok.length <= ++index) {
                                throw new ParserException("Required Color expected for ColorDefinition", src, linenr);
                            }
                            Color colorDefColor = null;
                            try {
                                colorDefColor = Color.decode(tok[index]);
                            }
                            catch (NumberFormatException e) {
                                throw new ParserException("Could not parse " + tok[index] + " as valid color", src, linenr);
                            }
                            aConfig.getColorDefinitionMap().put(colorDefName, colorDefColor);
                            continue block54;
                        }
                        case "Quantity": {
                            throw new ParserException("Quantity not supported by the conversion", src, linenr);
                        }
                        case "FilteringValues": {
                            int index = 1;
                            int afvid = Integer.parseInt(tok[index]);
                            if (!aConfig.getIdAttributeMap().containsKey(afvid)) {
                                throw new ParserException("Referenced Attribute(ID) does not exist " + tok[index], src, linenr);
                            }
                            Attribute attribute = aConfig.getAttribute(afvid);
                            if (tok.length <= ++index) {
                                throw new ParserException("At least 1 filtering value expected for FilteringValues", src, linenr);
                            }
                            while (index < tok.length) {
                                String filteringValue = tok[index++];
                                attribute.getAttributeFilteringValues().add(filteringValue.toCharArray());
                            }
                            continue block54;
                        }
                        default: {
                            throw new ParserException("Token not recognised " + tok[0], src, linenr);
                        }
                    }
                }
                if (tok[0].isEmpty()) continue;
                throw new ParserException("Expected another token after " + tok[0], src, linenr);
            }
            if (n_CONFIGURATIONID == 0) {
                throw new ParserException("Missing required ConfigurationID", src, 0);
            }
            if (n_TIMESCALESHIFT == 0) {
                throw new ParserException("Missing required TimeScaleShift", src, 0);
            }
            if (n_TIMESCALEUNIT == 0) {
                throw new ParserException("Missing required TimeScaleUnit", src, 0);
            }
            if (n_TIMEDISPLAYFORMAT != 0) return;
            throw new ParserException("Missing required TimeDisplayFormat", src, 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

