/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2uppaal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimMonitors;
import org.eclipse.escet.cif.cif2cif.ElimTauEvent;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2uppaal.CifToUppaalPreChecker;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifGuardUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.ConstantOrderer;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class CifToUppaal {
    private static final Set<String> RESERVED_KEYWORDS = Sets.set((Object[])new String[]{"chan", "clock", "bool", "int", "commit", "const", "urgent", "broadcast", "init", "process", "state", "guard", "sync", "assign", "system", "trans", "deadlock", "and", "or", "not", "imply", "true", "false", "for", "forall", "exists", "while", "do", "if", "else", "return", "typedef", "struct", "rate", "before_update", "after_update", "meta", "priority", "progress", "scalar", "select", "void", "default", "switch", "case", "continue", "break"});
    private Document doc;
    private Element ntaElem;
    private int nextLocId;
    private Map<Pair<PositionObject, String>, String> nameMap = Maps.map();
    private Set<String> names = Sets.set();

    public Document transform(Specification spec) {
        this.nextLocId = 0;
        this.nameMap = Maps.map();
        this.names = Sets.set();
        new RemoveIoDecls().transform(spec);
        new ElimComponentDefInst().transform(spec);
        new ElimTauEvent().transform(spec);
        new CifToUppaalPreChecker().check(spec);
        List events = Lists.list();
        List constants = Lists.list();
        List automata = Lists.list();
        List stateInvs = Lists.list();
        CifToUppaal.collectEvents((ComplexComponent)spec, events);
        CifToUppaal.collectConstants((ComplexComponent)spec, constants);
        CifToUppaal.collectAutomata((ComplexComponent)spec, automata);
        CifToUppaal.collectComponentStateInvs((ComplexComponent)spec, stateInvs);
        List variables = Lists.list();
        for (Automaton aut : automata) {
            for (Declaration decl : aut.getDeclarations()) {
                if (!(decl instanceof DiscVariable)) continue;
                variables.add((DiscVariable)decl);
            }
        }
        List<Integer> initLocIdxs = this.getInitLocsIdxs(automata);
        Automaton sendAut = CifConstructors.newAutomaton();
        sendAut.setName("SendAut");
        Specification sendSpec = CifConstructors.newSpecification();
        sendSpec.getComponents().add((Object)sendAut);
        this.doc = this.createUppaalXmlDocument();
        this.ntaElem = this.doc.getDocumentElement();
        MemoryCodeBox declsCode = new MemoryCodeBox(4);
        this.addChannels(events, (CodeBox)declsCode);
        this.addConstants(constants, (CodeBox)declsCode);
        this.addVariables(variables, (CodeBox)declsCode);
        this.addLocationPointers(automata, initLocIdxs, (CodeBox)declsCode);
        Element declsElem = this.doc.createElement("declaration");
        this.ntaElem.appendChild(declsElem);
        declsElem.setTextContent(declsCode.toString());
        List syncAlphabets = CifEventUtils.getAlphabets((List)automata);
        List sendAlphabets = CifEventUtils.getSendAlphabets((List)automata);
        List recvAlphabets = CifEventUtils.getReceiveAlphabets((List)automata);
        List moniAlphabets = CifEventUtils.getMonitors((List)automata, (List)syncAlphabets);
        List sendGuards = CifGuardUtils.mergeGuards((List)automata, (List)syncAlphabets, (List)sendAlphabets, (List)recvAlphabets, (List)moniAlphabets, (List)events, (CifGuardUtils.LocRefExprCreator)CifGuardUtils.LocRefExprCreator.DEFAULT);
        new ElimMonitors().transform(spec);
        this.addTemplates(automata, initLocIdxs, events, variables, stateInvs, sendAut, sendGuards);
        this.addSystem(automata, sendAut);
        return this.doc;
    }

    private List<Integer> getInitLocsIdxs(List<Automaton> automata) {
        List indices = Lists.listc((int)automata.size());
        for (Automaton aut : automata) {
            Set locs = CifLocationUtils.getPossibleInitialLocs((Automaton)aut, (boolean)true);
            Assert.check((locs.size() == 1 ? 1 : 0) != 0);
            Location loc = (Location)locs.iterator().next();
            int locIdx = aut.getLocations().indexOf((Object)loc);
            Assert.check((locIdx >= 0 ? 1 : 0) != 0);
            indices.add(locIdx);
        }
        return indices;
    }

    private Document createUppaalXmlDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        DOMImplementation domImpl = builder.getDOMImplementation();
        DocumentType docType = domImpl.createDocumentType("nta", "-//Uppaal Team//DTD Flat System 1.1//EN", "http://www.it.uu.se/research/group/darts/uppaal/flat-1_1.dtd");
        Document doc = domImpl.createDocument(null, "nta", docType);
        return doc;
    }

    private void addChannels(List<Event> events, CodeBox txt) {
        for (Event event : events) {
            txt.add("broadcast chan %s;", new Object[]{this.getUppaalName((PositionObject)event, null)});
        }
    }

    private void addConstants(List<Constant> constants, CodeBox txt) {
        constants = new ConstantOrderer().computeOrder(constants);
        for (Constant constant : constants) {
            txt.add("const %s %s = %s;", new Object[]{this.getUppaalType(constant.getType()), this.getUppaalName((PositionObject)constant, null), this.getUppaalExpr(constant.getValue(), false)});
        }
    }

    private void addVariables(List<DiscVariable> variables, CodeBox txt) {
        for (DiscVariable var : variables) {
            Expression value;
            if (var.getValue() == null) {
                value = CifValueUtils.getDefaultValue((CifType)var.getType(), null);
            } else {
                value = (Expression)var.getValue().getValues().get(0);
                try {
                    value = CifEvalUtils.evalAsExpr((Expression)value, (boolean)true);
                }
                catch (CifEvalException e) {
                    throw new RuntimeException(e);
                }
            }
            txt.add("%s %s = %s;", new Object[]{this.getUppaalType(var.getType()), this.getUppaalName((PositionObject)var, null), this.getUppaalExpr(value, false)});
            txt.add("meta %s %s = %s;", new Object[]{this.getUppaalType(var.getType()), this.getUppaalName((PositionObject)var, "OLD_"), this.getUppaalExpr(value, false)});
        }
    }

    private void addLocationPointers(List<Automaton> automata, List<Integer> initLocIdxs, CodeBox txt) {
        int i = 0;
        while (i < automata.size()) {
            Automaton aut = automata.get(i);
            int locCount = aut.getLocations().size();
            int locIdx = initLocIdxs.get(i);
            txt.add("int[0,%d] %s = %d;", new Object[]{locCount - 1, this.getUppaalName((PositionObject)aut, "LP_"), locIdx});
            txt.add("meta int[0,%d] %s = %d;", new Object[]{locCount - 1, this.getUppaalName((PositionObject)aut, "OLDLP_"), locIdx});
            ++i;
        }
    }

    private void addTemplates(List<Automaton> automata, List<Integer> initLocIdxs, List<Event> events, List<DiscVariable> variables, List<Expression> stateInvs, Automaton sendAut, List<Expression> sendGuards) {
        int i = 0;
        while (i < automata.size()) {
            this.addTemplate(automata.get(i), initLocIdxs.get(i));
            ++i;
        }
        this.addSendTemplate(sendAut, events, variables, automata, stateInvs, sendGuards);
    }

    private void addTemplate(Automaton aut, int initLocIdx) {
        Element templateElem = this.doc.createElement("template");
        this.ntaElem.appendChild(templateElem);
        Element templateNameElem = this.doc.createElement("name");
        templateElem.appendChild(templateNameElem);
        templateNameElem.setTextContent(this.getUppaalName((PositionObject)aut, "Template_"));
        int firstLocId = this.nextLocId;
        EList locations = aut.getLocations();
        for (Location loc : locations) {
            Element locElem = this.doc.createElement("location");
            templateElem.appendChild(locElem);
            locElem.setAttribute("id", "id" + Strings.str((Object)this.nextLocId));
            ++this.nextLocId;
            String locName = loc.getName();
            if (locName != null) {
                Element locNameElem = this.doc.createElement("name");
                locElem.appendChild(locNameElem);
                locNameElem.setTextContent(locName);
            }
            EList invs = loc.getInvariants();
            List invPreds = Lists.listc((int)invs.size());
            for (Invariant inv : invs) {
                Assert.check((inv.getInvKind() == InvKind.STATE ? 1 : 0) != 0);
                invPreds.add(inv.getPredicate());
            }
            if (!invPreds.isEmpty()) {
                Element invElem = this.doc.createElement("label");
                locElem.appendChild(invElem);
                invElem.setAttribute("kind", "invariant");
                invElem.setTextContent(this.getUppaalExpr(invPreds, false));
            }
            if (!loc.isUrgent()) continue;
            Element urgentElem = this.doc.createElement("urgent");
            locElem.appendChild(urgentElem);
        }
        Element initElem = this.doc.createElement("init");
        templateElem.appendChild(initElem);
        initElem.setAttribute("ref", "id" + Strings.str((Object)(firstLocId + initLocIdx)));
        int i = 0;
        while (i < locations.size()) {
            Location loc = (Location)locations.get(i);
            int sourceId = firstLocId + i;
            for (Edge edge : loc.getEdges()) {
                Location target = CifEdgeUtils.getTarget((Edge)edge);
                int targetIdx = locations.indexOf(target);
                Assert.check((targetIdx >= 0 ? 1 : 0) != 0);
                int targetId = firstLocId + targetIdx;
                EList edgeEvents = edge.getEvents();
                Assert.check((!edgeEvents.isEmpty() ? 1 : 0) != 0);
                for (EdgeEvent edgeEvent : edgeEvents) {
                    Element transitionElem = this.doc.createElement("transition");
                    templateElem.appendChild(transitionElem);
                    Element sourceElem = this.doc.createElement("source");
                    transitionElem.appendChild(sourceElem);
                    sourceElem.setAttribute("ref", "id" + Strings.str((Object)sourceId));
                    Element targetElem = this.doc.createElement("target");
                    transitionElem.appendChild(targetElem);
                    targetElem.setAttribute("ref", "id" + Strings.str((Object)targetId));
                    EList guards = edge.getGuards();
                    if (!guards.isEmpty()) {
                        Element guardElem = this.doc.createElement("label");
                        transitionElem.appendChild(guardElem);
                        guardElem.setAttribute("kind", "guard");
                        guardElem.setTextContent(this.getUppaalExpr((List<Expression>)guards, false));
                    }
                    Event event = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                    Element syncElem = this.doc.createElement("label");
                    transitionElem.appendChild(syncElem);
                    syncElem.setAttribute("kind", "synchronisation");
                    String chanName = this.getUppaalName((PositionObject)event, null);
                    syncElem.setTextContent(String.valueOf(chanName) + "?");
                    EList updates = edge.getUpdates();
                    List assignmentTxts = Lists.listc((int)(updates.size() + 1));
                    for (Update update : updates) {
                        String asgn = this.getUppaalAssignment((Assignment)update);
                        assignmentTxts.add(asgn);
                    }
                    assignmentTxts.add(Strings.fmt((String)"%s = %d", (Object[])new Object[]{this.getUppaalName((PositionObject)aut, "LP_"), targetIdx}));
                    String asgnTxt = StringUtils.join((Collection)assignmentTxts, (String)", ");
                    Element asgnElem = this.doc.createElement("label");
                    transitionElem.appendChild(asgnElem);
                    asgnElem.setAttribute("kind", "assignment");
                    asgnElem.setTextContent(asgnTxt);
                }
            }
            ++i;
        }
    }

    private void addSendTemplate(Automaton sendAut, List<Event> events, List<DiscVariable> variables, List<Automaton> automata, List<Expression> stateInvs, List<Expression> sendGuards) {
        Element templateElem = this.doc.createElement("template");
        this.ntaElem.appendChild(templateElem);
        Element templateNameElem = this.doc.createElement("name");
        templateElem.appendChild(templateNameElem);
        templateNameElem.setTextContent(this.getUppaalName((PositionObject)sendAut, "Template_"));
        int locId = this.nextLocId++;
        Element locElem = this.doc.createElement("location");
        templateElem.appendChild(locElem);
        locElem.setAttribute("id", "id" + Strings.str((Object)locId));
        if (!stateInvs.isEmpty()) {
            Element invElem = this.doc.createElement("label");
            locElem.appendChild(invElem);
            invElem.setAttribute("kind", "invariant");
            invElem.setTextContent(this.getUppaalExpr(stateInvs, false));
        }
        Element initElem = this.doc.createElement("init");
        templateElem.appendChild(initElem);
        initElem.setAttribute("ref", "id" + Strings.str((Object)locId));
        String asgnTxt = this.getSendAssignments(variables, automata);
        int i = 0;
        while (i < events.size()) {
            Event event = events.get(i);
            Element transitionElem = this.doc.createElement("transition");
            templateElem.appendChild(transitionElem);
            Element sourceElem = this.doc.createElement("source");
            transitionElem.appendChild(sourceElem);
            sourceElem.setAttribute("ref", "id" + Strings.str((Object)locId));
            Element targetElem = this.doc.createElement("target");
            transitionElem.appendChild(targetElem);
            targetElem.setAttribute("ref", "id" + Strings.str((Object)locId));
            Expression guard = sendGuards.get(i);
            Element guardElem = this.doc.createElement("label");
            transitionElem.appendChild(guardElem);
            guardElem.setAttribute("kind", "guard");
            guardElem.setTextContent(this.getUppaalExpr(guard, false));
            Element syncElem = this.doc.createElement("label");
            transitionElem.appendChild(syncElem);
            syncElem.setAttribute("kind", "synchronisation");
            String chanName = this.getUppaalName((PositionObject)event, null);
            syncElem.setTextContent(String.valueOf(chanName) + "!");
            Element asgnElem = this.doc.createElement("label");
            transitionElem.appendChild(asgnElem);
            asgnElem.setAttribute("kind", "assignment");
            asgnElem.setTextContent(asgnTxt);
            ++i;
        }
    }

    private String getSendAssignments(List<DiscVariable> variables, List<Automaton> automata) {
        List txts = Lists.listc((int)(variables.size() + automata.size()));
        for (DiscVariable var : variables) {
            txts.add(Strings.fmt((String)"%s = %s", (Object[])new Object[]{this.getUppaalName((PositionObject)var, "OLD_"), this.getUppaalName((PositionObject)var, null)}));
        }
        for (Automaton aut : automata) {
            txts.add(Strings.fmt((String)"%s = %s", (Object[])new Object[]{this.getUppaalName((PositionObject)aut, "OLDLP_"), this.getUppaalName((PositionObject)aut, "LP_")}));
        }
        return StringUtils.join((Collection)txts, (String)", ");
    }

    private void addSystem(List<Automaton> automata, Automaton sendAut) {
        List instantiations = Lists.listc((int)automata.size());
        MemoryCodeBox txt = new MemoryCodeBox(4);
        for (Automaton aut : automata) {
            txt.add("%s = %s();", new Object[]{this.getUppaalName((PositionObject)aut, null), this.getUppaalName((PositionObject)aut, "Template_")});
            instantiations.add(this.getUppaalName((PositionObject)aut, null));
        }
        txt.add("%s = %s();", new Object[]{this.getUppaalName((PositionObject)sendAut, null), this.getUppaalName((PositionObject)sendAut, "Template_")});
        instantiations.add(this.getUppaalName((PositionObject)sendAut, null));
        txt.add();
        txt.add("system %s;", new Object[]{StringUtils.join((Collection)instantiations, (String)", ")});
        Element systemElem = this.doc.createElement("system");
        this.ntaElem.appendChild(systemElem);
        systemElem.setTextContent(txt.toString());
    }

    private String getUppaalType(CifType type) {
        if (type instanceof BoolType) {
            return "bool";
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            int lower = CifTypeUtils.getLowerBound((IntType)itype);
            int upper = CifTypeUtils.getUpperBound((IntType)itype);
            return Strings.fmt((String)"int[%d,%d]", (Object[])new Object[]{lower, upper});
        }
        if (type instanceof TypeRef) {
            return this.getUppaalType(((TypeRef)type).getType().getType());
        }
        throw new RuntimeException("Unexpected type: " + type);
    }

    private String getUppaalExpr(List<Expression> preds, boolean old) {
        if (preds.isEmpty()) {
            return "true";
        }
        List txts = Lists.listc((int)preds.size());
        for (Expression pred : preds) {
            String txt = this.getUppaalExpr(pred, old);
            if (preds.size() > 1) {
                txt = "(" + txt + ")";
            }
            txts.add(txt);
        }
        return StringUtils.join((Collection)txts, (String)" && ");
    }

    private String getUppaalExpr(Expression expr, boolean old) {
        if (expr instanceof BoolExpression) {
            return ((BoolExpression)expr).isValue() ? "true" : "false";
        }
        if (expr instanceof IntExpression) {
            return Strings.str((Object)((IntExpression)expr).getValue());
        }
        if (expr instanceof CastExpression) {
            return this.getUppaalExpr(((CastExpression)expr).getChild(), old);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            String child = this.getUppaalExpr(uexpr.getChild(), old);
            UnaryOperator op = uexpr.getOperator();
            switch (op) {
                case INVERSE: {
                    return Strings.fmt((String)"!(%s)", (Object[])new Object[]{child});
                }
                case NEGATE: {
                    return Strings.fmt((String)"-(%s)", (Object[])new Object[]{child});
                }
                case PLUS: {
                    return child;
                }
            }
            throw new RuntimeException("Unexpected unop: " + op);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            String l = this.getUppaalExpr(bexpr.getLeft(), old);
            String r = this.getUppaalExpr(bexpr.getRight(), old);
            BinaryOperator op = bexpr.getOperator();
            switch (op) {
                case IMPLICATION: {
                    return Strings.fmt((String)"!(%s) || (%s)", (Object[])new Object[]{l, r});
                }
                case BI_CONDITIONAL: {
                    return Strings.fmt((String)"(%s) == (%s)", (Object[])new Object[]{l, r});
                }
                case CONJUNCTION: {
                    return Strings.fmt((String)"(%s) && (%s)", (Object[])new Object[]{l, r});
                }
                case DISJUNCTION: {
                    return Strings.fmt((String)"(%s) || (%s)", (Object[])new Object[]{l, r});
                }
                case GREATER_EQUAL: {
                    return Strings.fmt((String)"(%s) >= (%s)", (Object[])new Object[]{l, r});
                }
                case GREATER_THAN: {
                    return Strings.fmt((String)"(%s) > (%s)", (Object[])new Object[]{l, r});
                }
                case LESS_EQUAL: {
                    return Strings.fmt((String)"(%s) <= (%s)", (Object[])new Object[]{l, r});
                }
                case LESS_THAN: {
                    return Strings.fmt((String)"(%s) < (%s)", (Object[])new Object[]{l, r});
                }
                case EQUAL: {
                    return Strings.fmt((String)"(%s) == (%s)", (Object[])new Object[]{l, r});
                }
                case UNEQUAL: {
                    return Strings.fmt((String)"(%s) != (%s)", (Object[])new Object[]{l, r});
                }
                case ADDITION: {
                    return Strings.fmt((String)"(%s) + (%s)", (Object[])new Object[]{l, r});
                }
                case SUBTRACTION: {
                    return Strings.fmt((String)"(%s) - (%s)", (Object[])new Object[]{l, r});
                }
                case MULTIPLICATION: {
                    return Strings.fmt((String)"(%s) * (%s)", (Object[])new Object[]{l, r});
                }
                case INTEGER_DIVISION: {
                    return Strings.fmt((String)"(%s) / (%s)", (Object[])new Object[]{l, r});
                }
                case MODULUS: {
                    return Strings.fmt((String)"(%s) %% (%s)", (Object[])new Object[]{l, r});
                }
            }
            throw new RuntimeException("Unexpected binop: " + op);
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            String rslt = this.getUppaalExpr(ifExpr.getElse(), old);
            int i = ifExpr.getElifs().size() - 1;
            while (i >= 0) {
                ElifExpression elifExpr = (ElifExpression)ifExpr.getElifs().get(i);
                rslt = Strings.fmt((String)"(%s) ? (%s) : (%s)", (Object[])new Object[]{this.getUppaalExpr((List<Expression>)elifExpr.getGuards(), old), this.getUppaalExpr(elifExpr.getThen(), old), rslt});
                --i;
            }
            rslt = Strings.fmt((String)"(%s) ? (%s) : (%s)", (Object[])new Object[]{this.getUppaalExpr((List<Expression>)ifExpr.getGuards(), old), this.getUppaalExpr(ifExpr.getThen(), old), rslt});
            return rslt;
        }
        if (expr instanceof ConstantExpression) {
            return this.getUppaalName((PositionObject)((ConstantExpression)expr).getConstant(), null);
        }
        if (expr instanceof DiscVariableExpression) {
            String prefix = old ? "OLD_" : null;
            return this.getUppaalName((PositionObject)((DiscVariableExpression)expr).getVariable(), prefix);
        }
        if (expr instanceof LocationExpression) {
            Location loc = ((LocationExpression)expr).getLocation();
            Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
            int locIdx = aut.getLocations().indexOf((Object)loc);
            Assert.check((locIdx >= 0 ? 1 : 0) != 0);
            String prefix = old ? "OLDLP_" : "LP_";
            return Strings.fmt((String)"%s == %d", (Object[])new Object[]{this.getUppaalName((PositionObject)aut, prefix), locIdx});
        }
        throw new RuntimeException("Unexpected expr: " + expr);
    }

    private String getUppaalAssignment(Assignment asgn) {
        Expression addr = asgn.getAddressable();
        DiscVariable var = ((DiscVariableExpression)addr).getVariable();
        String name = this.getUppaalName((PositionObject)var, null);
        String valueTxt = this.getUppaalExpr(asgn.getValue(), true);
        return Strings.fmt((String)"%s = %s", (Object[])new Object[]{name, valueTxt});
    }

    private String getUppaalName(PositionObject obj, String prefix) {
        Pair pair = Pair.pair((Object)obj, (Object)prefix);
        String name = this.nameMap.get(pair);
        if (name != null) {
            return name;
        }
        String absName = CifTextUtils.getAbsName((PositionObject)obj);
        name = absName.replace('.', '_');
        if (prefix != null) {
            name = String.valueOf(prefix) + name;
        }
        if (this.names.contains(name) || RESERVED_KEYWORDS.contains(name)) {
            String oldName = name;
            name = CifScopeUtils.getUniqueName((String)name, this.names, RESERVED_KEYWORDS);
            OutputProvider.warn((String)"Using \"%s\" in UPPAAL for \"%s\" instead of \"%s\".", (Object[])new Object[]{name, absName, oldName});
        }
        this.nameMap.put((Pair<PositionObject, String>)pair, name);
        this.names.add(name);
        return name;
    }

    private static void collectEvents(ComplexComponent comp, List<Event> events) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event)) continue;
            events.add((Event)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToUppaal.collectEvents((ComplexComponent)child, events);
            }
        }
    }

    private static void collectConstants(ComplexComponent comp, List<Constant> constants) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Constant)) continue;
            constants.add((Constant)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToUppaal.collectConstants((ComplexComponent)child, constants);
            }
        }
    }

    private static void collectAutomata(ComplexComponent comp, List<Automaton> automata) {
        if (comp instanceof Automaton) {
            automata.add((Automaton)comp);
        } else {
            for (Component child : ((Group)comp).getComponents()) {
                CifToUppaal.collectAutomata((ComplexComponent)child, automata);
            }
        }
    }

    private static void collectComponentStateInvs(ComplexComponent comp, List<Expression> invs) {
        for (Invariant inv : comp.getInvariants()) {
            Assert.check((inv.getInvKind() == InvKind.STATE ? 1 : 0) != 0);
            invs.add(inv.getPredicate());
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToUppaal.collectComponentStateInvs((ComplexComponent)child, invs);
            }
        }
    }
}

