/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl.etl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeUnitEnum implements Enumerator
{
    S(0, "S", "s"),
    NS(1, "NS", "ns"),
    US(2, "US", "us"),
    MS(3, "MS", "ms"),
    MIN(4, "MIN", "min"),
    HR(5, "HR", "hr");

    public static final int S_VALUE = 0;
    public static final int NS_VALUE = 1;
    public static final int US_VALUE = 2;
    public static final int MS_VALUE = 3;
    public static final int MIN_VALUE = 4;
    public static final int HR_VALUE = 5;
    private static final TimeUnitEnum[] VALUES_ARRAY;
    public static final List<TimeUnitEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeUnitEnum[]{S, NS, US, MS, MIN, HR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeUnitEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnitEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnitEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnitEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnitEnum get(int value) {
        switch (value) {
            case 0: {
                return S;
            }
            case 1: {
                return NS;
            }
            case 2: {
                return US;
            }
            case 3: {
                return MS;
            }
            case 4: {
                return MIN;
            }
            case 5: {
                return HR;
            }
        }
        return null;
    }

    private TimeUnitEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

