/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.List;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class CommandLineUtils {
    private CommandLineUtils() {
    }

    public static String[] parseArgs(String args) {
        List<String> rslt = Lists.list();
        int pos = 0;
        boolean inArg = false;
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        boolean inEscape = false;
        StringBuilder b = null;
        while (pos < args.length()) {
            char c = args.charAt(pos);
            if (!inArg) {
                if (Character.isWhitespace(c)) {
                    ++pos;
                    continue;
                }
                b = new StringBuilder();
                inArg = true;
                continue;
            }
            if (inDoubleQuote) {
                if (inEscape) {
                    inEscape = false;
                    b.append(c);
                    ++pos;
                    continue;
                }
                if (c == '\"') {
                    inDoubleQuote = false;
                    ++pos;
                    continue;
                }
                if (c == '\\') {
                    inEscape = true;
                    ++pos;
                    continue;
                }
                b.append(c);
                ++pos;
                continue;
            }
            if (inSingleQuote) {
                if (inEscape) {
                    inEscape = false;
                    b.append(c);
                    ++pos;
                    continue;
                }
                if (c == '\'') {
                    inSingleQuote = false;
                    ++pos;
                    continue;
                }
                if (c == '\\') {
                    inEscape = true;
                    ++pos;
                    continue;
                }
                b.append(c);
                ++pos;
                continue;
            }
            if (inEscape) {
                inEscape = false;
                b.append(c);
                ++pos;
                continue;
            }
            if (Character.isWhitespace(c)) {
                inArg = false;
                rslt.add(b.toString());
                ++pos;
                continue;
            }
            if (c == '\"') {
                inDoubleQuote = true;
                ++pos;
                continue;
            }
            if (c == '\'') {
                inSingleQuote = true;
                ++pos;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                ++pos;
                continue;
            }
            b.append(c);
            ++pos;
        }
        if (inEscape) {
            String msg = Strings.fmt("Premature end of input: missing escaped character in \"%s\".", args);
            throw new IllegalArgumentException(msg);
        }
        if (inSingleQuote) {
            String msg = Strings.fmt("Premature end of input: missing end of single quote in \"%s\".", args);
            throw new IllegalArgumentException(msg);
        }
        if (inDoubleQuote) {
            String msg = Strings.fmt("Premature end of input: missing end of double quote in \"%s\".", args);
            throw new IllegalArgumentException(msg);
        }
        if (inArg) {
            rslt.add(b.toString());
        }
        return rslt.toArray(new String[0]);
    }

    public static String combineArgs(String[] args) {
        StringBuilder rslt = new StringBuilder();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (rslt.length() > 0) {
                rslt.append(" ");
            }
            if (Strings.containsWhitespace(arg)) {
                arg = arg.replace("\\", "\\\\").replace("\"", "\\\"");
                arg = "\"" + arg + "\"";
            } else {
                arg = arg.replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'");
            }
            rslt.append(arg);
            ++n2;
        }
        return rslt.toString();
    }
}

