/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public final class Exceptions {
    private Exceptions() {
    }

    public static String exToStr(Throwable ex) {
        List<String> rslt = Lists.list();
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "(" + ex.getClass().getSimpleName() + ") <no error message available>";
        }
        rslt.add("ERROR: " + exMsg);
        if (ex.getCause() != null) {
            Exceptions.exToStrAddCauses(ex.getCause(), rslt);
        }
        return StringUtils.join(rslt, (String)Strings.NL);
    }

    private static void exToStrAddCauses(Throwable ex, List<String> rslt) {
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "(" + ex.getClass().getSimpleName() + ") <cause details not available>";
        }
        rslt.add("CAUSE: " + exMsg);
        if (ex.getCause() != null) {
            Exceptions.exToStrAddCauses(ex.getCause(), rslt);
        }
    }

    public static String exToLine(Throwable ex) {
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "(" + ex.getClass().getSimpleName() + ") <no error message available>";
        }
        return ex.getCause() == null ? exMsg : String.valueOf(exMsg) + Exceptions.exToLineCauses(ex.getCause());
    }

    private static String exToLineCauses(Throwable ex) {
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "(" + ex.getClass().getSimpleName() + ") <cause details not available>";
        }
        exMsg = " / Cause: " + exMsg;
        return ex.getCause() == null ? exMsg : String.valueOf(exMsg) + Exceptions.exToLineCauses(ex.getCause());
    }
}

