/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2.storage;

import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.cif2mcrl2.storage.VarUsage;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Maps;

public class EventVarUsage {
    public final Event event;
    public Map<VariableData, VarUsage> varUses = Maps.map();

    public EventVarUsage(Event event) {
        this.event = event;
    }

    public void addReadEdgeAccess(Set<VariableData> vars, boolean firstEdge, Set<VariableData> localVars) {
        for (Map.Entry<VariableData, VarUsage> entry : this.varUses.entrySet()) {
            if (vars.contains(entry.getKey())) {
                entry.getValue().readAccess.everUsed = true;
                continue;
            }
            entry.getValue().readAccess.alwaysUsed = false;
        }
        for (VariableData vd : vars) {
            if (localVars.contains(vd) || this.varUses.containsKey(vd)) continue;
            VarUsage vu = new VarUsage(vd);
            vu.readAccess.everUsed = true;
            if (!firstEdge) {
                vu.readAccess.alwaysUsed = false;
            }
            this.varUses.put(vd, vu);
        }
    }

    public void addWriteEdgeAccess(Set<VariableData> vars, boolean firstEdge, Set<VariableData> localVars) {
        for (Map.Entry<VariableData, VarUsage> entry : this.varUses.entrySet()) {
            if (vars.contains(entry.getKey())) {
                entry.getValue().writeAccess.everUsed = true;
                continue;
            }
            entry.getValue().writeAccess.alwaysUsed = false;
        }
        for (VariableData vd : vars) {
            if (localVars.contains(vd) || this.varUses.containsKey(vd)) continue;
            VarUsage vu = new VarUsage(vd);
            vu.writeAccess.everUsed = true;
            if (!firstEdge) {
                vu.writeAccess.alwaysUsed = false;
            }
            this.varUses.put(vd, vu);
        }
    }
}

