/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2.tree;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.cif.cif2mcrl2.NameMaps;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.cif2mcrl2.tree.ProcessNode;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class VariableProcessNode
extends ProcessNode {
    public final VariableData variable;

    public VariableProcessNode(String name, VariableData variable) {
        super(name);
        this.variable = variable;
    }

    @Override
    protected String getCifName() {
        return "variable " + this.variable.name;
    }

    @Override
    public void deriveActions(Set<VariableData> localVars) {
        Assert.check((!localVars.contains(this.variable) ? 1 : 0) != 0);
        this.availProcessVars = Sets.set((Object)this.variable);
        this.valueVars = Sets.set((Object)this.variable);
        this.eventVarUse = Maps.map();
    }

    @Override
    public void addDefinitions(NameMaps names, Set<VariableData> localVars, VBox code) {
        String varProcName = names.getVariableProcess(this.variable.variable);
        String varType = names.getTypeName(this.variable.getType());
        String varValue = this.variable.getHasValueAction() ? names.getVariableValue(this.variable.variable) : null;
        String varRead = names.getVarRead(this.variable.variable);
        String behRead = names.getBehRead(this.variable.variable);
        String varSync = names.getVarSync(this.variable.variable);
        String varWrite = names.getVarWrite(this.variable.variable);
        String behWrite = names.getBehWrite(this.variable.variable);
        Integer bnd = this.variable.getLowerLimit();
        String lower = bnd == null ? null : Strings.fmt((String)"(m >= %d)", (Object[])new Object[]{bnd});
        bnd = this.variable.getUpperLimit();
        String upper = bnd == null ? null : Strings.fmt((String)"(m <= %d)", (Object[])new Object[]{bnd});
        String sumText = "sum m:" + varType;
        String sumPrefix = lower == null ? (upper == null ? String.valueOf(sumText) + " . true" : String.valueOf(sumText) + " . " + upper) : (upper == null ? String.valueOf(sumText) + " . " + lower : String.valueOf(sumText) + " . (" + lower + " && " + upper + ")");
        List actions = Lists.list();
        if (varValue != null) {
            actions.add(varValue);
        }
        actions.add(varRead);
        actions.add(varWrite);
        actions.add(varSync);
        actions.add(behRead);
        actions.add(behWrite);
        String actionsStr = StringUtils.join((Collection)actions, (String)", ");
        code.add(Strings.fmt((String)"act %s : %s;", (Object[])new Object[]{actionsStr, varType}));
        code.add();
        code.add(Strings.fmt((String)"proc %s(v:%s) =", (Object[])new Object[]{varProcName, varType}));
        if (varValue != null) {
            code.add(Strings.fmt((String)"  %s(v) . %s(v) +", (Object[])new Object[]{varValue, varProcName}));
        }
        code.add(Strings.fmt((String)"  %s(v) . %s(v) +", (Object[])new Object[]{varRead, varProcName}));
        code.add(Strings.fmt((String)"  %s -> %s(m) . %s(m) +", (Object[])new Object[]{sumPrefix, varWrite, varProcName}));
        code.add(Strings.fmt((String)"  %s -> %s(v) | %s(m) . %s(m);", (Object[])new Object[]{sumPrefix, varRead, varWrite, varProcName}));
        code.add();
    }

    @Override
    public void addInstantiations(NameMaps names, Set<VariableData> localVars, VBox code) {
        String varProcess = names.getVariableProcess(this.variable.variable);
        code.add(Strings.fmt((String)"%s(%s)", (Object[])new Object[]{varProcess, this.variable.initialValue}));
    }
}

