/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.preference;

import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class IntegerFieldEditorWithHelp
extends IntegerFieldEditor {
    public static final String ICONS_PREFERENCES_HELP = "icons/full/others/prefshelp.gif";
    private static final int DEFAULT_TEXT_LIMIT = 10;
    private String helpText;

    public IntegerFieldEditorWithHelp(String name, String label, String helpText, Composite parent) {
        this.helpText = helpText;
        this.init(name, label);
        this.setTextLimit(10);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(JFaceResources.getString((String)"IntegerFieldEditor.errorMessage"));
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns - 1);
        Label image = new Label(parent, 0);
        image.setImage(this.getHelpIcon());
        image.setToolTipText(this.helpText);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        image.setLayoutData((Object)gd);
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected Image getHelpIcon() {
        ImageDescriptor findImageDescriptor = SiriusEditPlugin.Implementation.findImageDescriptor(ICONS_PREFERENCES_HELP);
        return SiriusEditPlugin.getPlugin().getImage(findImageDescriptor);
    }
}

