/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.mpt.ui;

import activity.ActivitySet;
import activity.util.Event2Resource;
import activity.util.PassiveClaimTransformer;
import dispatching.ActivityDispatching;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.stream.Collectors;
import machine.ImportContainer;
import machine.util.ImportsFlattener;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsat.common.emf.ecore.resource.Persistor;
import org.eclipse.lsat.common.emf.ecore.resource.PersistorFactory;
import org.eclipse.lsat.common.emf.ecore.resource.ResourceSetUtil;
import org.eclipse.lsat.common.mpt.MaxPlusSpecification;
import org.eclipse.lsat.common.qvto.util.QvtoTransformationException;
import org.eclipse.lsat.mpt.transformation.Activity2Graph;
import org.eclipse.lsat.mpt.transformation.ExpandActivities;
import org.eclipse.lsat.mpt.transformation.ReduceActivityDispatching;
import org.eclipse.lsat.mpt.transformation.Specification2MptMatrix;
import org.eclipse.lsat.mpt.transformation.Specification2MptMatrixInput;
import org.eclipse.lsat.mpt.ui.ActivityTransformationOptions;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.service.OperationCanceledError;
import setting.SettingUtil;
import setting.Settings;

public class Activity2DispatchingHelper {
    private static final String BULLET = "\u2022";
    private final ActivityTransformationOptions options;
    private ActivitySet activitySet;
    private URI dispatchingFileURI;
    private String dispatchingFile;
    private URI resultFolderURI;
    private boolean isExpanded;
    private ActivitySet orgActivitySet;
    private URI intermediateBaseURI;

    public Activity2DispatchingHelper(ActivityTransformationOptions options) {
        this.options = options;
    }

    protected MaxPlusSpecification createMaxPlusSpecification(IProgressMonitor monitor) throws IOException, QvtoTransformationException, CoreException {
        monitor.beginTask("Converting activity specification to max-plus model", 100);
        monitor.subTask("Converting " + this.options.getActivityFile().getName());
        PersistorFactory factory = new PersistorFactory();
        URI modelURI = URI.createPlatformResourceURI((String)this.options.getActivityFile().getFullPath().toString(), (boolean)true);
        URI cifURI = URI.createPlatformResourceURI((String)this.options.getCifFile().getFullPath().toString(), (boolean)true);
        IFolder saveIFolder = this.options.getActivityFile().getProject().getFolder("result");
        this.resultFolderURI = URI.createPlatformResourceURI((String)saveIFolder.getFullPath().toString(), (boolean)true);
        String cifFileName = cifURI.trimFileExtension().lastSegment();
        String dispatchingFileName = cifFileName.concat(this.options.getDispatchingFileExtension());
        URI saveBaseURI = this.resultFolderURI.appendSegment(dispatchingFileName);
        this.intermediateBaseURI = this.resultFolderURI.appendSegment(".intermediate").appendSegment(dispatchingFileName);
        this.dispatchingFileURI = saveBaseURI.appendFileExtension("dispatching");
        this.dispatchingFile = String.valueOf(dispatchingFileName) + ".dispatching";
        Persistor activityPersistor = factory.getPersistor(ActivitySet.class);
        this.orgActivitySet = (ActivitySet)activityPersistor.loadOne(modelURI);
        Settings settings = SettingUtil.getSettings((Resource)this.orgActivitySet.eResource());
        ResourceSet resourceSet = ImportsFlattener.flatten((URI)this.intermediateBaseURI, (ImportContainer[])new ImportContainer[]{this.orgActivitySet, settings});
        this.activitySet = (ActivitySet)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, ActivitySet.class);
        settings = (Settings)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, Settings.class);
        monitor.subTask("Processing passive claims...");
        PassiveClaimTransformer.transform((ActivitySet)this.activitySet);
        monitor.subTask("Expanding activities...");
        ExpandActivities.expand((ActivitySet)this.activitySet);
        boolean bl = this.isExpanded = !EcoreUtil.equals((EObject)this.activitySet, (EObject)this.orgActivitySet);
        if (this.isExpanded) {
            ResourceSetUtil.saveResources((ResourceSet)resourceSet, Collections.emptyMap());
            IFolder intermediateFolder = saveIFolder.getFolder(".intermediate");
            intermediateFolder.setHidden(true);
        }
        monitor.subTask("Preparing activity specification...");
        Activity2Graph activities2Graph = new Activity2Graph();
        this.activitySet = (ActivitySet)activities2Graph.transformModel((Object)this.activitySet, monitor);
        monitor.worked(30);
        monitor.subTask("Adding CIF supervisor " + this.options.getCifFile().getName());
        URI cifSpecificationURI = URI.createPlatformResourceURI((String)this.options.getCifFile().getFullPath().toString(), (boolean)true);
        Persistor cifSpecificationPersistor = factory.getPersistor(Specification.class);
        Specification cifSpecification = (Specification)cifSpecificationPersistor.loadOne(cifSpecificationURI);
        Event2Resource.replaceEventsWithClaimRelease((ActivitySet)this.activitySet);
        Specification2MptMatrixInput mptMatrixInput = new Specification2MptMatrixInput(this.activitySet, settings, cifSpecification);
        Specification2MptMatrix specification2mptMatrix = new Specification2MptMatrix();
        return (MaxPlusSpecification)specification2mptMatrix.transformModel((Object)mptMatrixInput, monitor);
    }

    protected void createDispatchingFile(CharSequence dispatchingContent) throws URISyntaxException, IOException {
        ExtensibleURIConverterImpl convertor = new ExtensibleURIConverterImpl();
        if (this.isExpanded) {
            URI expanded = this.intermediateBaseURI.appendFileExtension(this.dispatchingFileURI.fileExtension());
            Throwable throwable = null;
            Object var5_10 = null;
            try (PrintWriter writer = new PrintWriter(convertor.createOutputStream(expanded));){
                writer.write(dispatchingContent.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            PersistorFactory factory = new PersistorFactory();
            Persistor savePersistor = factory.getPersistor(ActivityDispatching.class);
            ActivityDispatching dispatching = (ActivityDispatching)savePersistor.loadOne(expanded);
            ReduceActivityDispatching.reduce((ActivityDispatching)dispatching, (ActivitySet)this.orgActivitySet);
            SaveOptions options = SaveOptions.newBuilder().format().getOptions();
            savePersistor.save(this.dispatchingFileURI, options.toOptionsMap(), new EObject[]{dispatching});
            this.validate(dispatching);
        } else {
            Throwable throwable = null;
            Object var4_8 = null;
            try (PrintWriter writer = new PrintWriter(convertor.createOutputStream(this.dispatchingFileURI));){
                writer.write(dispatchingContent.toString());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private void validate(ActivityDispatching dispatching) throws OperationCanceledError, IOException {
        Diagnostic diagnostics = Diagnostician.INSTANCE.validate((EObject)dispatching);
        if (diagnostics.getSeverity() == 4) {
            String msg = "\nGenerated dispatching file invalid:\n\n" + diagnostics.getChildren().stream().map(d -> "  \u2022 " + d.getMessage()).collect(Collectors.joining("\n"));
            throw new IllegalArgumentException(msg);
        }
    }

    public ActivitySet getActivitySet() {
        return this.activitySet;
    }

    public URI getResultFolderURI() {
        return this.resultFolderURI;
    }

    public String getDispatchingFile() {
        return this.dispatchingFile;
    }

    public String round(Double d) {
        DecimalFormat df = new DecimalFormat("###.######");
        return df.format(d);
    }

    public static class SuccessDialog
    extends MessageDialog {
        public SuccessDialog(Shell parent, String title, String message) {
            super(parent, title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        }

        public Image getImage() {
            return null;
        }
    }
}

