/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.box;

import java.util.List;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.Boxable;
import org.eclipse.escet.common.java.Strings;

public abstract class CodeBox
extends Box {
    private int indentAmount;
    private int indentLevel = 0;

    public CodeBox(int indentAmount) {
        if (indentAmount <= 0) {
            String msg = "indentAmount must be positive";
            throw new IllegalArgumentException(msg);
        }
        this.indentAmount = indentAmount;
    }

    public abstract boolean isEmpty();

    public void setIndentAmount(int amount) {
        if (amount <= 0) {
            String msg = "indentAmount must be positive";
            throw new IllegalArgumentException(msg);
        }
        this.indentAmount = amount;
    }

    public int getIndentAmount() {
        return this.indentAmount;
    }

    public void indent() {
        ++this.indentLevel;
    }

    public void dedent() {
        if (this.indentLevel == 0) {
            throw new IllegalStateException("Can't dedent: level already 0.");
        }
        --this.indentLevel;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public String getIndentation() {
        return Strings.spaces((int)(this.indentLevel * this.indentAmount));
    }

    protected abstract void addLine(String var1);

    public void add() {
        this.addLine("");
    }

    public void add(String line) {
        if (this.indentLevel > 0) {
            line = String.valueOf(this.getIndentation()) + line;
        }
        this.addLine(line);
    }

    public void add(String line, Object ... args) {
        this.add(Strings.fmt((String)line, (Object[])args));
    }

    public void add(List<String> lines) {
        for (String line : lines) {
            this.add(line);
        }
    }

    public void add(String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.add(line);
            ++n2;
        }
    }

    public void add(Box box) {
        this.add(box.getLines());
    }

    public void add(Boxable obj) {
        this.add(obj.toBox().getLines());
    }
}

