/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.io;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Strings;

public class FileAppStream
extends AppStream {
    private final String relPath;
    private final OutputStream stream;

    public FileAppStream(String path) {
        this(path, false);
    }

    public FileAppStream(String relPath, String absPath) {
        this(relPath, absPath, false);
    }

    public FileAppStream(String path, boolean append) {
        this(path, Paths.resolve(path), append);
    }

    public FileAppStream(String relPath, String absPath, boolean append) {
        FileOutputStream fileStream;
        this.relPath = relPath;
        try {
            fileStream = new FileOutputStream(absPath, append);
        }
        catch (FileNotFoundException ex) {
            String msg = Strings.fmt((String)"Failed to open file \"%s\" for writing, as it already exists as a directory, can not be created, or can not be opened for writing.", (Object[])new Object[]{relPath});
            throw new InputOutputException(msg, ex);
        }
        this.stream = new BufferedOutputStream(fileStream);
    }

    @Override
    protected void writeImpl(byte b) {
        try {
            this.stream.write(b);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to write to file \"%s\".", (Object[])new Object[]{this.relPath});
            throw new InputOutputException(msg, ex);
        }
    }

    @Override
    protected void writeImpl(byte[] bytes, int offset, int length) {
        try {
            this.stream.write(bytes, offset, length);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to write to file \"%s\".", (Object[])new Object[]{this.relPath});
            throw new InputOutputException(msg, ex);
        }
    }

    @Override
    protected void flushImpl() {
        try {
            this.stream.flush();
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to flush file \"%s\".", (Object[])new Object[]{this.relPath});
            throw new InputOutputException(msg, ex);
        }
    }

    @Override
    protected void closeImpl() {
        try {
            this.stream.close();
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{this.relPath});
            throw new InputOutputException(msg, ex);
        }
    }
}

