/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.common.java.Strings;

public class TypeCodeGenerator {
    private TypeCodeGenerator() {
    }

    public static String gencodeType(CifType type, CifCompilerContext ctxt) {
        return TypeCodeGenerator.gencodeType(type, ctxt, false);
    }

    public static String gencodeType(CifType type, CifCompilerContext ctxt, boolean generic) {
        if (type instanceof BoolType) {
            return generic ? "Boolean" : "boolean";
        }
        if (type instanceof IntType) {
            return generic ? "Integer" : "int";
        }
        if (type instanceof TypeRef) {
            return TypeCodeGenerator.gencodeType(((TypeRef)type).getType().getType(), ctxt, generic);
        }
        if (type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            return ctxt.getEnumClassName(enumDecl);
        }
        if (type instanceof RealType) {
            return generic ? "Double" : "double";
        }
        if (type instanceof StringType) {
            return "String";
        }
        if (type instanceof ListType) {
            CifType etype = ((ListType)type).getElementType();
            return Strings.fmt((String)"List<%s>", (Object[])new Object[]{TypeCodeGenerator.gencodeType(etype, ctxt, true)});
        }
        if (type instanceof SetType) {
            CifType etype = ((SetType)type).getElementType();
            return Strings.fmt((String)"Set<%s>", (Object[])new Object[]{TypeCodeGenerator.gencodeType(etype, ctxt, true)});
        }
        if (type instanceof FuncType) {
            return ctxt.getFuncTypeClassName((FuncType)type);
        }
        if (type instanceof DictType) {
            CifType ktype = ((DictType)type).getKeyType();
            CifType vtype = ((DictType)type).getValueType();
            return Strings.fmt((String)"Map<%s, %s>", (Object[])new Object[]{TypeCodeGenerator.gencodeType(ktype, ctxt, true), TypeCodeGenerator.gencodeType(vtype, ctxt, true)});
        }
        if (type instanceof TupleType) {
            return ctxt.getTupleTypeClassName((TupleType)type);
        }
        if (type instanceof DistType) {
            DistType dtype = (DistType)type;
            CifType nstype = CifTypeUtils.normalizeType((CifType)dtype.getSampleType());
            if (nstype instanceof BoolType) {
                return "BooleanDistribution";
            }
            if (nstype instanceof IntType) {
                return "IntegerDistribution";
            }
            if (nstype instanceof RealType) {
                return "RealDistribution";
            }
            String msg = "Unknown distribution sample type: " + nstype;
            throw new RuntimeException(msg);
        }
        if (type instanceof VoidType) {
            throw new RuntimeException("Unexpected void type: " + type);
        }
        throw new RuntimeException("Unexpected type: " + type);
    }
}

