/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.input;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.input.InteractiveGuiInputChoice;
import org.eclipse.escet.cif.simulator.input.InteractiveGuiInputComponent;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEvent;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.ode.Trajectories;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.eclipse.ui.SelectionListenerBase;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class InteractiveGuiInputEditor<S extends RuntimeState>
extends ControlEditor {
    private static final int COLOR_COMP_IDX = 0;
    private static final int BUTTON_IDX = 1;
    private static final int CNT_LBL_IDX = 2;
    private static final int ARROW_IDX = 3;
    private RuntimeSpec<S> spec = null;
    private InteractiveGuiInputComponent<?> inputComp = null;
    private Color otherColor = null;
    private Color eventColor = null;
    private Color ctrlColor = null;
    private Color unctrlColor = null;
    private Color disabledColor = null;
    private ScrolledComposite scroll = null;
    private Composite buttons = null;
    private Font italicFont = null;
    private Menu popupMenu = null;
    private List<Transition<S>> transitions = null;
    private S state = null;
    public final AtomicBoolean ready = new AtomicBoolean(false);
    public final AtomicReference<InteractiveGuiInputChoice> choice = new AtomicReference<Object>(null);

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.scroll = new ScrolledComposite(parent, 256);
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(true);
        this.buttons = new Composite((Composite)this.scroll, 0);
        this.scroll.setContent((Control)this.buttons);
        Color white = this.buttons.getDisplay().getSystemColor(1);
        this.buttons.setBackground(white);
        this.scroll.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = InteractiveGuiInputEditor.this.scroll.getClientArea();
                InteractiveGuiInputEditor.this.scroll.setMinSize(InteractiveGuiInputEditor.this.buttons.computeSize(-1, r.height));
            }
        });
        RowLayout row = new RowLayout(512);
        row.wrap = true;
        row.fill = true;
        row.spacing = 3;
        this.buttons.setLayout((Layout)row);
        this.popupMenu = new Menu((Control)this.buttons);
        this.otherColor = this.buttons.getDisplay().getSystemColor(2);
        this.eventColor = new Color((Device)parent.getDisplay(), 0, 97, 192);
        this.ctrlColor = new Color((Device)parent.getDisplay(), 0, 128, 0);
        this.unctrlColor = new Color((Device)parent.getDisplay(), 160, 0, 0);
        this.disabledColor = new Color((Device)parent.getDisplay(), 192, 192, 192);
        FontData[] fontDatas = this.buttons.getFont().getFontData();
        fontDatas[0].setStyle(fontDatas[0].getStyle() | 2);
        this.italicFont = new Font((Device)parent.getDisplay(), fontDatas);
        this.scroll.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InteractiveGuiInputEditor.this.inform(new InteractiveGuiInputChoice());
            }
        });
        return this.scroll;
    }

    public void init(RuntimeSpec<S> spec, InteractiveGuiInputComponent<?> input) {
        this.spec = spec;
        this.inputComp = input;
        int cnt = spec.events.size() + 3;
        int i = 0;
        while (i < cnt) {
            boolean isUndo;
            final boolean isEvent = i < spec.events.size();
            final boolean isTime = i == spec.events.size();
            final boolean isReset = i == spec.events.size() + 1;
            boolean bl = isUndo = i == spec.events.size() + 2;
            if (!(isEvent && input.autoEvents[i] || isTime && input.autoTime && input.autoTimeDur || isReset && !input.isResetEnabled || isUndo && !input.isUndoEnabled)) {
                RuntimeEvent event;
                RuntimeEvent runtimeEvent = event = isEvent ? spec.events.get(i) : null;
                if (event == null || !event.isTauEvent || spec.hasTauEdge()) {
                    String kind;
                    Composite comp = new Composite(this.buttons, 2048);
                    comp.setData("eventIdx", (Object)(isEvent ? i : -1));
                    if (isEvent) {
                        kind = "event";
                    } else if (isTime) {
                        kind = "time";
                    } else if (isReset) {
                        kind = "reset";
                    } else if (isUndo) {
                        kind = "undo";
                    } else {
                        throw new RuntimeException("Unknown transition.");
                    }
                    comp.setData("kind", (Object)kind);
                    Composite colorComp = new Composite(comp, 0);
                    Button button = new Button(comp, 8);
                    button.setAlignment(16384);
                    if (event != null && !spec.urgent[i]) {
                        button.setFont(this.italicFont);
                    }
                    if (isEvent) {
                        if (event == null) {
                            throw new RuntimeException();
                        }
                        button.setText(event.name);
                    } else if (isTime) {
                        button.setText("time delay");
                    } else if (isReset) {
                        button.setText("reset");
                    } else if (isUndo) {
                        button.setText("undo");
                    } else {
                        throw new RuntimeException("Unknown button.");
                    }
                    button.setForeground(this.getColor(event, true));
                    final int eventIdx = i;
                    button.addSelectionListener((SelectionListener)new SelectionListenerBase(){

                        public void widgetSelected(SelectionEvent e) {
                            InteractiveGuiInputChoice choiceData = new InteractiveGuiInputChoice();
                            if (isTime) {
                                choiceData.timeChosen = true;
                                if (((InteractiveGuiInputEditor)InteractiveGuiInputEditor.this).inputComp.autoTimeDur) {
                                    choiceData.targetTime = null;
                                } else {
                                    ChosenTargetTime targetTime;
                                    List filtered = Lists.filter((List)InteractiveGuiInputEditor.this.transitions, TimeTransition.class);
                                    Assert.check((filtered.size() == 1 ? 1 : 0) != 0);
                                    TimeTransition transition = (TimeTransition)Lists.first((List)filtered);
                                    double timePre = transition.source.getTime();
                                    double timePost = transition.getLastTime();
                                    choiceData.targetTime = targetTime = new ChosenTargetTime(timePre, timePost, true);
                                }
                            } else if (isEvent) {
                                choiceData.eventIdx = eventIdx;
                            } else if (isReset) {
                                choiceData.resetChosen = true;
                            } else if (isUndo) {
                                choiceData.undoCount = 1;
                            } else {
                                throw new RuntimeException("Unknown button.");
                            }
                            InteractiveGuiInputEditor.this.inform(choiceData);
                        }
                    });
                    Label countLabel = new Label(comp, 0);
                    countLabel.setText("");
                    final Button arrow = new Button(comp, 1028);
                    arrow.addSelectionListener((SelectionListener)new SelectionListenerBase(){

                        public void widgetSelected(SelectionEvent e) {
                            Point pos = arrow.toDisplay(e.x, e.y);
                            int height = arrow.getSize().y;
                            InteractiveGuiInputEditor.this.addPopupMenuItems(event, kind);
                            InteractiveGuiInputEditor.this.popupMenu.setLocation(pos.x, pos.y + height);
                            InteractiveGuiInputEditor.this.popupMenu.setVisible(true);
                        }
                    });
                    colorComp.setBackground(this.getColor(event, false));
                    button.setEnabled(false);
                    arrow.setEnabled(false);
                    GridLayout gridLayout = new GridLayout(4, false);
                    gridLayout.marginWidth = 0;
                    gridLayout.marginHeight = 0;
                    gridLayout.horizontalSpacing = 2;
                    comp.setLayout((Layout)gridLayout);
                    int buttonHeight = button.computeSize((int)-1, (int)-1, (boolean)true).y;
                    GridData colorCompData = new GridData();
                    colorCompData.widthHint = 4;
                    colorCompData.heightHint = buttonHeight;
                    colorComp.setLayoutData((Object)colorCompData);
                    GridData buttonData = new GridData();
                    buttonData.horizontalAlignment = 4;
                    buttonData.grabExcessHorizontalSpace = true;
                    button.setLayoutData((Object)buttonData);
                }
            }
            ++i;
        }
        this.buttons.pack();
        this.buttons.layout();
        this.scroll.notifyListeners(16, null);
    }

    private Color getColor(RuntimeEvent<?> event, boolean enabled) {
        if (!enabled) {
            return this.disabledColor;
        }
        if (event == null) {
            return this.otherColor;
        }
        if (event.controllable == null) {
            return this.eventColor;
        }
        if (event.controllable.booleanValue()) {
            return this.ctrlColor;
        }
        return this.unctrlColor;
    }

    public void chooseTransition(S state, List<Transition<S>> transitions) {
        this.transitions = transitions;
        this.state = state;
        int[] counts = new int[this.spec.events.size()];
        TimeTransition timeTrans = null;
        for (Transition<S> transition : transitions) {
            if (transition instanceof EventTransition) {
                int eventIdx;
                int n = eventIdx = ((EventTransition)transition).event.idx;
                counts[n] = counts[n] + 1;
                continue;
            }
            Assert.check((boolean)(transition instanceof TimeTransition));
            timeTrans = (TimeTransition)transition;
        }
        boolean resetPossible = false;
        int maxUndoCount = 0;
        if (this.inputComp.history != null) {
            resetPossible = this.inputComp.history.canReset((RuntimeState)state);
            maxUndoCount = this.inputComp.history.getMaxUndoCount((RuntimeState)state);
        }
        Control firstEnabledButton = null;
        Control[] controlArray = this.buttons.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control buttonsChild = controlArray[n2];
            if (buttonsChild instanceof Composite) {
                String cntTxt;
                boolean enabled;
                boolean isUndo;
                Composite comp = (Composite)buttonsChild;
                Control[] children = comp.getChildren();
                Object eventIdxObj = comp.getData("eventIdx");
                int eventIdx = (Integer)eventIdxObj;
                Object kindObj = comp.getData("kind");
                boolean isEvent = eventIdx >= 0;
                boolean isTime = !isEvent && kindObj.equals("time");
                boolean isReset = !isEvent && kindObj.equals("reset");
                boolean bl = isUndo = !isEvent && kindObj.equals("undo");
                int count = isEvent ? counts[eventIdx] : (isTime ? (timeTrans == null ? 0 : 1) : (isReset ? (resetPossible ? 1 : 0) : (isUndo ? maxUndoCount : -1)));
                boolean bl2 = enabled = count > 0;
                if (isEvent) {
                    cntTxt = count <= 1 ? "" : Strings.fmt((String)"(%d)", (Object[])new Object[]{count});
                } else if (isTime && timeTrans == null) {
                    cntTxt = "";
                } else if (isTime && timeTrans != null) {
                    double maxDelay = timeTrans.getTrajectories().getMaxDelay();
                    cntTxt = Strings.fmt((String)"(~%.3g)", (Object[])new Object[]{maxDelay});
                } else if (isReset) {
                    cntTxt = "";
                } else if (isUndo) {
                    cntTxt = enabled ? Strings.fmt((String)"(%d)", (Object[])new Object[]{count}) : "";
                } else {
                    throw new RuntimeException("Unknown transition.");
                }
                Label cntLbl = (Label)children[2];
                if (!cntLbl.getText().equals(cntTxt)) {
                    cntLbl.setText(cntTxt);
                    comp.pack();
                    comp.layout();
                }
                RuntimeEvent event = isEvent ? this.spec.events.get(eventIdx) : null;
                children[0].setBackground(this.getColor(event, enabled));
                children[1].setEnabled(enabled);
                children[3].setEnabled(enabled);
                if (enabled && firstEnabledButton == null) {
                    firstEnabledButton = children[1];
                }
            }
            ++n2;
        }
        this.buttons.pack();
        this.buttons.layout();
        if (firstEnabledButton != null) {
            firstEnabledButton.setFocus();
        }
    }

    public void chooseDelay(S state, double maxTargetTime) {
        Trajectories trajs = new Trajectories();
        trajs.add(((RuntimeState)state).getTime(), new double[0]);
        trajs.add(maxTargetTime, new double[0]);
        this.transitions = Lists.list(new TimeTransition<S>(this.spec, state, trajs));
        this.state = state;
        Control firstEnabledButton = null;
        Control[] controlArray = this.buttons.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control buttonsChild = controlArray[n2];
            if (buttonsChild instanceof Composite) {
                Composite comp = (Composite)buttonsChild;
                Control[] children = comp.getChildren();
                Object kindObj = comp.getData("kind");
                if (kindObj.equals("time")) {
                    double maxDelay = trajs.getMaxDelay();
                    String cntTxt = Strings.fmt((String)"(~%.3g)", (Object[])new Object[]{maxDelay});
                    Label cntLbl = (Label)children[2];
                    if (!cntLbl.getText().equals(cntTxt)) {
                        cntLbl.setText(cntTxt);
                        comp.pack();
                        comp.layout();
                    }
                    children[0].setBackground(this.getColor(null, true));
                    children[1].setEnabled(true);
                    children[3].setEnabled(true);
                    if (firstEnabledButton == null) {
                        firstEnabledButton = children[1];
                    }
                }
            }
            ++n2;
        }
        this.buttons.pack();
        this.buttons.layout();
        if (firstEnabledButton != null) {
            firstEnabledButton.setFocus();
        }
    }

    public void chooseNoTransition(S state) {
        this.transitions = Collections.EMPTY_LIST;
        this.state = state;
        Assert.check((this.inputComp.history != null ? 1 : 0) != 0);
        boolean resetPossible = this.inputComp.history.canReset((RuntimeState)state);
        int maxUndoCount = this.inputComp.history.getMaxUndoCount((RuntimeState)state);
        Control firstEnabledButton = null;
        Control[] controlArray = this.buttons.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control buttonsChild = controlArray[n2];
            if (buttonsChild instanceof Composite) {
                Composite comp = (Composite)buttonsChild;
                Control[] children = comp.getChildren();
                Object kindObj = comp.getData("kind");
                boolean isReset = kindObj.equals("reset");
                boolean isUndo = kindObj.equals("undo");
                if (isReset || isUndo) {
                    String cntTxt;
                    boolean enabled;
                    int count = isReset ? (resetPossible ? 1 : 0) : (isUndo ? maxUndoCount : -1);
                    boolean bl = enabled = count > 0;
                    if (isReset) {
                        cntTxt = "";
                    } else if (isUndo) {
                        cntTxt = enabled ? Strings.fmt((String)"(%d)", (Object[])new Object[]{count}) : "";
                    } else {
                        throw new RuntimeException("Unknown transition.");
                    }
                    Label cntLbl = (Label)children[2];
                    if (!cntLbl.getText().equals(cntTxt)) {
                        cntLbl.setText(cntTxt);
                        comp.pack();
                        comp.layout();
                    }
                    children[0].setBackground(this.getColor(null, enabled));
                    children[1].setEnabled(enabled);
                    children[3].setEnabled(enabled);
                    if (enabled && firstEnabledButton == null) {
                        firstEnabledButton = children[1];
                    }
                }
            }
            ++n2;
        }
        this.buttons.pack();
        this.buttons.layout();
        if (firstEnabledButton != null) {
            firstEnabledButton.setFocus();
        }
    }

    private void addPopupMenuItems(RuntimeEvent<?> event, String kind) {
        this.removePopupMenuItems();
        if (event != null) {
            int i = 0;
            while (i < this.transitions.size()) {
                Transition<S> transition = this.transitions.get(i);
                if (transition instanceof EventTransition && ((EventTransition)transition).event == event) {
                    MenuItem item = new MenuItem(this.popupMenu, 0);
                    item.setText(transition.toString());
                    final int transIdx = i;
                    item.addSelectionListener((SelectionListener)new SelectionListenerBase(){

                        public void widgetSelected(SelectionEvent e) {
                            InteractiveGuiInputChoice choiceData = new InteractiveGuiInputChoice();
                            choiceData.transIdx = transIdx;
                            InteractiveGuiInputEditor.this.inform(choiceData);
                        }
                    });
                }
                ++i;
            }
        } else if (kind.equals("time")) {
            List filtered = Lists.filter(this.transitions, TimeTransition.class);
            Assert.check((filtered.size() == 1 ? 1 : 0) != 0);
            final TimeTransition transition = (TimeTransition)Lists.first((List)filtered);
            String description = transition.toString();
            MenuItem[] menuItems = new MenuItem[3];
            boolean AUTO_IDX = false;
            boolean CUSTOM_IDX = true;
            int MAX_IDX = 2;
            if (this.inputComp.autoTimeDur) {
                menuItems[0] = new MenuItem(this.popupMenu, 0);
                menuItems[0].setText(String.valueOf(description) + ", automatic duration");
            } else {
                menuItems[1] = new MenuItem(this.popupMenu, 0);
                menuItems[1].setText(String.valueOf(description) + ", custom duration...");
                menuItems[2] = new MenuItem(this.popupMenu, 0);
                menuItems[2].setText(String.valueOf(description) + ", maximum duration");
            }
            int i = 0;
            while (i < menuItems.length) {
                if (menuItems[i] != null) {
                    final int idx = i;
                    menuItems[i].addSelectionListener((SelectionListener)new SelectionListenerBase(){

                        public void widgetSelected(SelectionEvent e) {
                            InteractiveGuiInputChoice choiceData = new InteractiveGuiInputChoice();
                            choiceData.timeChosen = true;
                            switch (idx) {
                                case 0: {
                                    choiceData.targetTime = null;
                                    break;
                                }
                                case 1: {
                                    ChosenTargetTime targetTime;
                                    Double delay = InteractiveGuiInputEditor.this.enterDelayDuration(transition);
                                    if (delay == null) {
                                        return;
                                    }
                                    double timePre = transition.source.getTime();
                                    double timePost = transition.getLastTime();
                                    double time = timePre + delay;
                                    if (time > timePost) {
                                        time = timePost;
                                    }
                                    choiceData.targetTime = targetTime = new ChosenTargetTime(timePre, time, false);
                                    break;
                                }
                                case 2: {
                                    ChosenTargetTime targetTime;
                                    double timePre = transition.source.getTime();
                                    double timePost = transition.getLastTime();
                                    choiceData.targetTime = targetTime = new ChosenTargetTime(timePre, timePost, true);
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("idx: " + idx);
                                }
                            }
                            InteractiveGuiInputEditor.this.inform(choiceData);
                        }
                    });
                }
                ++i;
            }
        } else if (kind.equals("reset")) {
            MenuItem menuItem = new MenuItem(this.popupMenu, 0);
            menuItem.setText("reset to initial state");
            menuItem.addSelectionListener((SelectionListener)new SelectionListenerBase(){

                public void widgetSelected(SelectionEvent e) {
                    InteractiveGuiInputChoice choiceData = new InteractiveGuiInputChoice();
                    choiceData.resetChosen = true;
                    InteractiveGuiInputEditor.this.inform(choiceData);
                }
            });
        } else if (kind.equals("undo")) {
            boolean addCustom;
            final int maxUndoCount = this.inputComp.history.getMaxUndoCount((RuntimeState)this.state);
            int itemCount = Math.min(10, maxUndoCount);
            boolean bl = addCustom = itemCount != maxUndoCount;
            if (addCustom) {
                ++itemCount;
            }
            MenuItem[] menuItems = new MenuItem[itemCount];
            int i = 0;
            while (i < itemCount) {
                menuItems[i] = new MenuItem(this.popupMenu, 0);
                String description = i == 0 ? "undo 1 transition" : (addCustom && i == itemCount - 1 ? Strings.fmt((String)"undo custom number of transitions", (Object[])new Object[]{i}) : Strings.fmt((String)"undo %,d transitions", (Object[])new Object[]{i + 1}));
                menuItems[i].setText(description);
                ++i;
            }
            final int customIdx = addCustom ? itemCount - 1 : -1;
            int i2 = 0;
            while (i2 < itemCount) {
                final int idx = i2;
                menuItems[i2].addSelectionListener((SelectionListener)new SelectionListenerBase(){

                    public void widgetSelected(SelectionEvent e) {
                        InteractiveGuiInputChoice choiceData = new InteractiveGuiInputChoice();
                        choiceData.timeChosen = true;
                        if (idx == customIdx) {
                            Integer count = InteractiveGuiInputEditor.this.enterUndoCount(maxUndoCount);
                            if (count == null) {
                                return;
                            }
                            choiceData.undoCount = count;
                        } else {
                            choiceData.undoCount = idx + 1;
                        }
                        InteractiveGuiInputEditor.this.inform(choiceData);
                    }
                });
                ++i2;
            }
        } else {
            throw new RuntimeException("Unknown kind: " + kind);
        }
    }

    private void removePopupMenuItems() {
        MenuItem[] items;
        if (this.popupMenu == null) {
            return;
        }
        if (this.popupMenu.isDisposed()) {
            return;
        }
        MenuItem[] menuItemArray = items = this.popupMenu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
    }

    private Double enterDelayDuration(TimeTransition<S> transition) {
        final double timePre = transition.source.getTime();
        double timePost = transition.getLastTime();
        final double maxDelay = timePost - timePre;
        Assert.check((maxDelay > 0.0 ? 1 : 0) != 0);
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                double duration;
                try {
                    duration = Double.parseDouble(newText);
                }
                catch (NumberFormatException ex) {
                    return Strings.fmt((String)"Failed to parse delay duration \"%s\".", (Object[])new Object[]{newText});
                }
                if (Double.isNaN(duration)) {
                    return Strings.fmt((String)"Invalid delay duration \"%s\".", (Object[])new Object[]{newText});
                }
                if (Double.isInfinite(duration)) {
                    return Strings.fmt((String)"Invalid infinite delay duration \"%s\".", (Object[])new Object[]{newText});
                }
                if (duration <= 0.0 || maxDelay < duration) {
                    return Strings.fmt((String)"Delay duration \"%s\" is not in range (0 .. %s].", (Object[])new Object[]{newText, CifSimulatorMath.realToStr(maxDelay)});
                }
                double targetTime = timePre + duration;
                if (targetTime == timePre) {
                    return Strings.fmt((String)"Target time \"%s\" after delay \"%s\" is too close to the current time \"%s\".", (Object[])new Object[]{CifSimulatorMath.realToStr(targetTime), newText, CifSimulatorMath.realToStr(timePre)});
                }
                return null;
            }
        };
        String title = "Time transition duration";
        String msg = Strings.fmt((String)"Specify a time transition duration in the range (0 .. %s]:", (Object[])new Object[]{maxDelay});
        InputDialog dialog = new InputDialog(this.contents.getShell(), title, msg, CifSimulatorMath.realToStr(maxDelay), validator);
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        return Double.parseDouble(dialog.getValue());
    }

    private Integer enterUndoCount(final int maxUndoCount) {
        Assert.check((maxUndoCount > 0 ? 1 : 0) != 0);
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                int count;
                try {
                    count = Integer.parseInt(newText);
                }
                catch (NumberFormatException ex) {
                    return Strings.fmt((String)"Failed to parse undo count \"%s\".", (Object[])new Object[]{newText});
                }
                if (count < 1 || maxUndoCount < count) {
                    return Strings.fmt((String)"Undo count \"%s\" is not in range [1 .. %,d].", (Object[])new Object[]{newText, maxUndoCount});
                }
                return null;
            }
        };
        String title = "Number of transitions to undo";
        String msg = Strings.fmt((String)"Specify an undo count in the range [1 .. %,d]:", (Object[])new Object[]{maxUndoCount});
        InputDialog dialog = new InputDialog(this.contents.getShell(), title, msg, Strings.str((Object)maxUndoCount), validator);
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        return Integer.parseInt(dialog.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inform(InteractiveGuiInputChoice data) {
        this.transitions = null;
        this.state = null;
        this.removePopupMenuItems();
        Control[] controlArray = this.buttons.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control buttonsChild = controlArray[n2];
            if (buttonsChild instanceof Composite) {
                Composite comp = (Composite)buttonsChild;
                Control[] children = comp.getChildren();
                Object eventIdxObj = comp.getData("eventIdx");
                int eventIdx = (Integer)eventIdxObj;
                Label cntLbl = (Label)children[2];
                if (!cntLbl.getText().isEmpty()) {
                    cntLbl.setText("");
                    comp.pack();
                    comp.layout();
                }
                RuntimeEvent event = eventIdx == -1 ? null : this.spec.events.get(eventIdx);
                children[0].setBackground(this.getColor(event, false));
                children[1].setEnabled(false);
                children[3].setEnabled(false);
            }
            ++n2;
        }
        this.buttons.pack();
        this.buttons.layout();
        this.choice.set(data);
        AtomicBoolean atomicBoolean = this.ready;
        synchronized (atomicBoolean) {
            this.ready.set(true);
            this.ready.notify();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        this.italicFont = null;
        if (this.eventColor != null) {
            this.eventColor.dispose();
        }
        if (this.ctrlColor != null) {
            this.ctrlColor.dispose();
        }
        if (this.unctrlColor != null) {
            this.unctrlColor.dispose();
        }
        if (this.disabledColor != null) {
            this.disabledColor.dispose();
        }
        this.otherColor = null;
        this.eventColor = null;
        this.ctrlColor = null;
        this.unctrlColor = null;
        this.disabledColor = null;
    }
}

