/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CodeGenPreChecker
extends CifWalker {
    protected List<String> problems = Lists.list();
    protected int autCount;
    protected int initLocCount;

    public void check(Specification spec) {
        this.walkSpecification(spec);
        Collections.sort(this.problems, Strings.SORTER);
        if (!this.problems.isEmpty()) {
            String msg = "CIF code generator failed due to unsatisfied preconditions:\n - " + StringUtils.join(this.problems, (String)"\n - ");
            throw new UnsupportedException(msg);
        }
    }

    protected void postprocessSpecification(Specification spec) {
        if (this.autCount == 0) {
            String msg = "Unsupported specification: specifications without automata are currently not supported.";
            this.problems.add(msg);
        }
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        if (!CifValueUtils.isTriviallyTrue((List)comp.getInitials(), (boolean)true, (boolean)true)) {
            String msg = Strings.fmt((String)"Unsupported %s: initialization predicates in components are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            this.problems.add(msg);
        }
        List invPreds = Lists.listc((int)comp.getInvariants().size());
        for (Invariant inv : comp.getInvariants()) {
            if (inv.getInvKind() != InvKind.STATE) {
                String msg = Strings.fmt((String)"Unsupported %s: state/event exclusion invariants are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
                this.problems.add(msg);
                continue;
            }
            invPreds.add(inv.getPredicate());
        }
        if (!CifValueUtils.isTriviallyTrue((List)invPreds, (boolean)false, (boolean)true)) {
            String msg = Strings.fmt((String)"Unsupported %s: state invariants in components are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            this.problems.add(msg);
        }
    }

    protected void preprocessDiscVariable(DiscVariable var) {
        EObject parent = var.eContainer();
        if (!(parent instanceof ComplexComponent)) {
            return;
        }
        VariableValue values = var.getValue();
        if (values != null && values.getValues().size() != 1) {
            String msg = Strings.fmt((String)"Unsupported discrete variable \"%s\": the variable has multiple potential initial values.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            this.problems.add(msg);
        }
    }

    protected void preprocessExternalFunction(ExternalFunction func) {
        String msg = Strings.fmt((String)"Unsupported function \"%s\": external user-defined functions are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)func)});
        this.problems.add(msg);
    }

    protected void preprocessLocation(Location loc) {
        String msg;
        if (loc.isUrgent()) {
            String msg2 = Strings.fmt((String)"Unsupported %s: urgent locations are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg2);
        }
        List invPreds = Lists.listc((int)loc.getInvariants().size());
        for (Invariant inv : loc.getInvariants()) {
            if (inv.getInvKind() != InvKind.STATE) {
                msg = Strings.fmt((String)"Unsupported %s: state/event exclusion invariants are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                this.problems.add(msg);
                continue;
            }
            invPreds.add(inv.getPredicate());
        }
        if (!CifValueUtils.isTriviallyTrue((List)invPreds, (boolean)false, (boolean)true)) {
            String msg3 = Strings.fmt((String)"Unsupported %s: state invariants in locations are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg3);
        }
        boolean initial = false;
        try {
            initial = loc.getInitials().isEmpty() ? false : CifEvalUtils.evalPreds((List)loc.getInitials(), (boolean)true, (boolean)true);
        }
        catch (CifEvalException e) {
            msg = Strings.fmt((String)"Failed to (statically) evaluate initialization predicate(s): %s.", (Object[])new Object[]{CifTextUtils.exprsToStr((List)loc.getInitials())});
            this.problems.add(msg);
            this.initLocCount = -1;
        }
        if (initial && this.initLocCount != -1) {
            ++this.initLocCount;
        }
    }

    protected void preprocessEdge(Edge edge) {
        if (edge.isUrgent()) {
            Location loc = (Location)edge.eContainer();
            String msg = Strings.fmt((String)"Unsupported %s: urgent edges are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg);
        }
    }

    protected void preprocessAutomaton(Automaton aut) {
        this.initLocCount = 0;
        ++this.autCount;
    }

    protected void postprocessAutomaton(Automaton aut) {
        String msg;
        if (this.initLocCount == 0) {
            msg = Strings.fmt((String)"Unsupported automaton \"%s\": automata without an initial location are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            this.problems.add(msg);
        }
        if (this.initLocCount > 1) {
            msg = Strings.fmt((String)"Unsupported automaton \"%s\": automata with multiple initial locations are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            this.problems.add(msg);
        }
    }

    protected void preprocessDictType(DictType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": dictionary types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessDistType(DistType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": distribution types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessFuncType(FuncType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": function types are currently not supported. That is, calling functions is supported, but using them as data is not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessListType(ListType type) {
        if (CifTypeUtils.isArrayType((ListType)type)) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported type \"%s\": non-array list types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessSetType(SetType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": set types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void walkCifType(CifType type) {
        EObject parent = type.eContainer();
        if (parent instanceof Expression) {
            return;
        }
        super.walkCifType(type);
    }

    protected void preprocessUnaryExpression(UnaryExpression expr) {
        UnaryOperator op = expr.getOperator();
        switch (op) {
            case INVERSE: 
            case NEGATE: 
            case PLUS: {
                return;
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": unary operator \"%s\" is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((UnaryOperator)op)});
        this.problems.add(msg);
    }

    protected void preprocessBinaryExpression(BinaryExpression expr) {
        BinaryOperator op = expr.getOperator();
        switch (op) {
            case IMPLICATION: 
            case BI_CONDITIONAL: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case MODULUS: 
            case INTEGER_DIVISION: 
            case MULTIPLICATION: 
            case DIVISION: {
                return;
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (!(ltype instanceof BoolType)) break;
                return;
            }
            case EQUAL: 
            case UNEQUAL: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (!(ltype instanceof BoolType) && !(ltype instanceof IntType) && !(ltype instanceof RealType) && !(ltype instanceof EnumType) && !(ltype instanceof StringType)) break;
                return;
            }
            case ADDITION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (!(ltype instanceof IntType) && !(ltype instanceof RealType) && !(ltype instanceof StringType)) break;
                return;
            }
            case SUBTRACTION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (!(ltype instanceof IntType) && !(ltype instanceof RealType)) break;
                return;
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": binary operator \"%s\" is currently not supported, or is not supported for the operands that are used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((BinaryOperator)op)});
        this.problems.add(msg);
    }

    protected void preprocessProjectionExpression(ProjectionExpression expr) {
        CifType ctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
        if (ctype instanceof TupleType) {
            return;
        }
        if (ctype instanceof StringType) {
            return;
        }
        if (ctype instanceof ListType && CifTypeUtils.isArrayType((ListType)((ListType)ctype))) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": projections on anything other than tuples, arrays, and strings is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSliceExpression(SliceExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": slicing is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessFunctionCallExpression(FunctionCallExpression expr) {
        Expression fexpr = expr.getFunction();
        if (fexpr instanceof FunctionExpression) {
            return;
        }
        if (fexpr instanceof StdLibFunctionExpression) {
            StdLibFunctionExpression lExpr = (StdLibFunctionExpression)fexpr;
            StdLibFunction stdlib = lExpr.getFunction();
            switch (stdlib) {
                case MINIMUM: 
                case MAXIMUM: 
                case POWER: 
                case SIGN: 
                case CBRT: 
                case CEIL: 
                case EXP: 
                case FLOOR: 
                case LN: 
                case LOG: 
                case ROUND: 
                case SQRT: 
                case ACOS: 
                case ASIN: 
                case ATAN: 
                case COS: 
                case SIN: 
                case TAN: 
                case ABS: 
                case FORMAT: 
                case SCALE: {
                    return;
                }
                case EMPTY: {
                    CifType ptype = CifTypeUtils.normalizeType((CifType)((Expression)expr.getParams().get(0)).getType());
                    if (!(ptype instanceof ListType) || !CifTypeUtils.isArrayType((ListType)((ListType)ptype))) break;
                    return;
                }
                case SIZE: {
                    CifType ptype = CifTypeUtils.normalizeType((CifType)((Expression)expr.getParams().get(0)).getType());
                    if (ptype instanceof StringType) {
                        return;
                    }
                    if (!(ptype instanceof ListType) || !CifTypeUtils.isArrayType((ListType)((ListType)ptype))) break;
                    return;
                }
                case DELETE: 
                case POP: 
                case ACOSH: 
                case ASINH: 
                case ATANH: 
                case COSH: 
                case SINH: 
                case TANH: {
                    break;
                }
            }
            String msg = Strings.fmt((String)"Unsupported expression \"%s\": standard  library function \"%s\" is currently not supported, or is not supported for the arguments that are used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.functionToStr((StdLibFunction)stdlib)});
            this.problems.add(msg);
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": function calls on anything other than standard library functions and internal user-defined functions is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSetExpression(SetExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": sets are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessDictExpression(DictExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": dictionaries are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessFunctionExpression(FunctionExpression expr) {
        FunctionCallExpression fcexpr;
        if (expr.eContainer() instanceof FunctionCallExpression && (fcexpr = (FunctionCallExpression)expr.eContainer()).getFunction() == expr) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": the use of functions as values is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessPrint(Print print) {
        String msg;
        if (print.getTxtPre() != null && print.getWhenPost() != null) {
            msg = "Unsupported print declaration: print declarations with pre/source state text and post/target state filtering (\"when\") are currently not supported.";
            this.problems.add(msg);
        }
        if (print.getTxtPost() != null && print.getWhenPre() != null) {
            msg = "Unsupported print declaration: print declarations with post/target state text and pre/source state filtering (\"when\") are currently not supported.";
            this.problems.add(msg);
        }
    }
}

