/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c99;

import java.util.Collection;
import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CurlyBraceIfElseGenerator;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.FunctionCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c99.C99DataValue;
import org.eclipse.escet.cif.codegen.c99.typeinfos.C99TypeInfoHelper;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.common.FuncLocalVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;

public class C99FunctionCodeGen
extends FunctionCodeGen {
    public final boolean genLocalFunctions;

    public C99FunctionCodeGen(boolean genLocalFunctions, InternalFunction function) {
        super(function);
        this.genLocalFunctions = genLocalFunctions;
    }

    public void generate(CodeBox declCode, CodeBox defCode, CodeContext ctxt) {
        Destination dest;
        Object paramVar;
        int varBase = ctxt.reserveTempVariables();
        int paramCount = this.function.getParameters().size();
        int refParamCount = 0;
        VariableInformation[] paramVars = new VariableInformation[paramCount];
        int i = 0;
        while (i < paramCount) {
            paramVars[i] = ctxt.getWriteVarInfo((Declaration)((FunctionParameter)this.function.getParameters().get(i)).getParameter());
            if (!C99TypeInfoHelper.typeUsesValues(paramVars[i].typeInfo)) {
                ++refParamCount;
            }
            ++i;
        }
        Object localVars = this.function.getVariables();
        localVars = new FuncLocalVarOrderer().computeOrder((Collection)localVars);
        Assert.notNull((Object)localVars);
        VariableInformation[] localVarInfos = new VariableInformation[refParamCount + localVars.size()];
        int localIndex = 0;
        MemoryCodeBox vardeclCode = ctxt.makeCodeBox();
        int i2 = 0;
        while (i2 < paramCount) {
            if (!C99TypeInfoHelper.typeUsesValues(paramVars[i2].typeInfo)) {
                localVarInfos[localIndex] = paramVar = paramVars[i2];
                ++localIndex;
                paramVars[i2] = ctxt.makeTempVariable((VariableInformation)paramVar);
                ((VariableInformation)paramVar).isReference = false;
                C99DataValue src = C99DataValue.makeReference(paramVars[i2].targetName);
                dest = new Destination(null, ((VariableInformation)paramVar).typeInfo, C99DataValue.makeValue(((VariableInformation)paramVar).targetName));
                ((VariableInformation)paramVar).typeInfo.declareInit((CodeBox)vardeclCode, src, dest);
            }
            ++i2;
        }
        paramVar = localVars.iterator();
        while (paramVar.hasNext()) {
            VariableInformation localVar;
            DiscVariable var = (DiscVariable)paramVar.next();
            localVarInfos[localIndex] = localVar = ctxt.getWriteVarInfo((Declaration)var);
            ++localIndex;
            vardeclCode.add("%s %s;", new Object[]{localVar.typeInfo.getTargetType(), localVar.targetName});
            dest = new Destination(null, localVar.typeInfo, C99DataValue.makeValue(localVar.targetName));
            Assert.notNull((Object)var.getValue());
            Assert.check((var.getValue().getValues().size() == 1 ? 1 : 0) != 0);
            ExprCode initCode = ctxt.exprToTarget((Expression)var.getValue().getValues().get(0), dest);
            vardeclCode.add((Box)initCode.getCode());
        }
        Assert.check((localIndex == localVarInfos.length ? 1 : 0) != 0);
        TypeInfo returnTi = ctxt.typeToTarget(this.getReturnType());
        StringBuilder fnHeader = new StringBuilder();
        fnHeader.append(returnTi.getTargetType());
        fnHeader.append(" ");
        String funcName = ctxt.getFunctionName(this.function);
        fnHeader.append(funcName);
        fnHeader.append('(');
        int i3 = 0;
        while (i3 < paramCount) {
            if (i3 > 0) {
                fnHeader.append(", ");
            }
            if (C99TypeInfoHelper.typeUsesValues(paramVars[i3].typeInfo)) {
                fnHeader.append(paramVars[i3].typeInfo.getTargetType());
                fnHeader.append(' ');
                fnHeader.append(paramVars[i3].targetName);
            } else {
                fnHeader.append(paramVars[i3].typeInfo.getTargetType());
                fnHeader.append("* ");
                fnHeader.append(paramVars[i3].targetName);
            }
            ++i3;
        }
        fnHeader.append(")");
        String header = fnHeader.toString();
        if (this.genLocalFunctions) {
            declCode.add("static %s;", new Object[]{header});
            defCode.add("static " + header + " {");
        } else {
            declCode.add("extern %s;", new Object[]{header});
            defCode.add(String.valueOf(header) + " {");
        }
        defCode.indent();
        if (localVarInfos.length > 0) {
            defCode.add((Box)vardeclCode);
            defCode.add();
        }
        this.addFuncStatements((List<FunctionStatement>)this.function.getStatements(), defCode, ctxt);
        defCode.add("assert(0); /* Falling through the end of the function. */");
        defCode.dedent();
        defCode.add("}");
        ctxt.unreserveTempVariables(varBase);
    }

    @Override
    protected IfElseGenerator getIfElseFuncGenerator() {
        return new CurlyBraceIfElseGenerator();
    }

    @Override
    protected void generateBreakFuncStatement(CodeBox code) {
        code.add("break;");
    }

    @Override
    protected void generateContinueFuncStatement(CodeBox code) {
        code.add("continue;");
    }

    @Override
    protected void generateReturnFuncStatement(Expression retValue, CodeBox code, boolean safeScope, CodeContext ctxt) {
        ExprCode retCode = ctxt.exprToTarget(retValue, null);
        CodeBox exprCode = retCode.getCode();
        if (exprCode.isEmpty()) {
            safeScope = true;
        }
        if (!safeScope) {
            ctxt.addUpdatesBeginScope(code);
        }
        code.add((Box)exprCode);
        code.add("return %s;", new Object[]{retCode.getData()});
        if (!safeScope) {
            ctxt.addUpdatesEndScope(code);
        }
    }

    @Override
    protected boolean generateWhileFuncStatement(ExprCode guardCode, CodeBox code, boolean safeScope) {
        if (guardCode.hasCode()) {
            code.add("for (;;) {");
            code.indent();
            code.add((Box)guardCode.getCode());
            code.add("if (%s) break;", new Object[]{guardCode.getData()});
            code.add();
            safeScope = false;
        } else {
            code.add("while (%s) {", new Object[]{guardCode.getData()});
            code.indent();
        }
        return safeScope;
    }

    @Override
    protected void generateEndWhileFuncStatement(CodeBox code) {
        code.dedent();
        code.add("}");
    }
}

