/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.logicalstructures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILogicalStructureProvider;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.logicalstructures.IJavaStructuresListener;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructure;
import org.osgi.service.prefs.BackingStoreException;

public class JavaLogicalStructures
implements ILogicalStructureProvider {
    static final char IS_SUBTYPE_TRUE = 'T';
    static final char IS_SUBTYPE_FALSE = 'F';
    private static Map<String, List<JavaLogicalStructure>> fJavaLogicalStructureMap;
    private static List<JavaLogicalStructure> fPluginContributedJavaLogicalStructures;
    private static List<JavaLogicalStructure> fUserDefinedJavaLogicalStructures;
    private static Set<IJavaStructuresListener> fListeners;
    private static final String PREF_JAVA_LOGICAL_STRUCTURES;

    static {
        fListeners = new HashSet<IJavaStructuresListener>();
        PREF_JAVA_LOGICAL_STRUCTURES = String.valueOf(JDIDebugModel.getPluginIdentifier()) + ".PREF_JAVA_LOGICAL_STRUCTURES";
        JavaLogicalStructures.initPluginContributedJavaLogicalStructure();
        JavaLogicalStructures.initUserDefinedJavaLogicalStructures();
        JavaLogicalStructures.initJavaLogicalStructureMap();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (prefs != null) {
            prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new PreferenceListener());
        }
    }

    private static void initJavaLogicalStructureMap() {
        fJavaLogicalStructureMap = new HashMap<String, List<JavaLogicalStructure>>();
        JavaLogicalStructures.addAllLogicalStructures(fPluginContributedJavaLogicalStructures);
        JavaLogicalStructures.addAllLogicalStructures(fUserDefinedJavaLogicalStructures);
    }

    private static void addAllLogicalStructures(List<JavaLogicalStructure> pluginContributedJavaLogicalStructures) {
        for (JavaLogicalStructure logicalStructure : pluginContributedJavaLogicalStructures) {
            JavaLogicalStructures.addLogicalStructure(logicalStructure);
        }
    }

    private static void addLogicalStructure(JavaLogicalStructure structure) {
        String typeName = structure.getQualifiedTypeName();
        List<JavaLogicalStructure> logicalStructure = fJavaLogicalStructureMap.get(typeName);
        if (logicalStructure == null) {
            logicalStructure = new ArrayList<JavaLogicalStructure>();
            fJavaLogicalStructureMap.put(typeName, logicalStructure);
        }
        logicalStructure.add(structure);
    }

    private static void initPluginContributedJavaLogicalStructure() {
        IConfigurationElement[] javaLogicalStructureElements;
        fPluginContributedJavaLogicalStructures = new ArrayList<JavaLogicalStructure>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(JDIDebugPlugin.getUniqueIdentifier(), "javaLogicalStructures");
        IConfigurationElement[] iConfigurationElementArray = javaLogicalStructureElements = extensionPoint.getConfigurationElements();
        int n = javaLogicalStructureElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement javaLogicalStructureElement = iConfigurationElementArray[n2];
            try {
                fPluginContributedJavaLogicalStructures.add(new JavaLogicalStructure(javaLogicalStructureElement));
            }
            catch (CoreException e) {
                JDIDebugPlugin.log(e);
            }
            ++n2;
        }
    }

    private static void initUserDefinedJavaLogicalStructures() {
        fUserDefinedJavaLogicalStructures = new ArrayList<JavaLogicalStructure>();
        String logicalStructuresString = Platform.getPreferencesService().getString(JDIDebugPlugin.getUniqueIdentifier(), PREF_JAVA_LOGICAL_STRUCTURES, "", null);
        StringTokenizer tokenizer = new StringTokenizer(logicalStructuresString, "\u0000", true);
        while (tokenizer.hasMoreTokens()) {
            String type = tokenizer.nextToken();
            tokenizer.nextToken();
            String description = tokenizer.nextToken();
            tokenizer.nextToken();
            String isSubtypeValue = tokenizer.nextToken();
            boolean isSubtype = isSubtypeValue.charAt(0) == 'T';
            tokenizer.nextToken();
            String value = tokenizer.nextToken();
            if (value.charAt(0) == '\u0000') {
                value = null;
            } else {
                tokenizer.nextToken();
            }
            String variablesCounterValue = tokenizer.nextToken();
            int variablesCounter = Integer.parseInt(variablesCounterValue);
            tokenizer.nextToken();
            String[][] variables = new String[variablesCounter][2];
            int i = 0;
            while (i < variablesCounter) {
                variables[i][0] = tokenizer.nextToken();
                tokenizer.nextToken();
                variables[i][1] = tokenizer.nextToken();
                tokenizer.nextToken();
                ++i;
            }
            fUserDefinedJavaLogicalStructures.add(new JavaLogicalStructure(type, isSubtype, value, description, variables));
        }
    }

    public static void saveUserDefinedJavaLogicalStructures() {
        StringBuilder logicalStructuresString = new StringBuilder();
        for (JavaLogicalStructure logicalStructure : fUserDefinedJavaLogicalStructures) {
            logicalStructuresString.append(logicalStructure.getQualifiedTypeName()).append('\u0000');
            logicalStructuresString.append(logicalStructure.getDescription()).append('\u0000');
            logicalStructuresString.append(logicalStructure.isSubtypes() ? (char)'T' : 'F').append('\u0000');
            String value = logicalStructure.getValue();
            if (value != null) {
                logicalStructuresString.append(value);
            }
            logicalStructuresString.append('\u0000');
            String[][] variables = logicalStructure.getVariables();
            logicalStructuresString.append(variables.length).append('\u0000');
            String[][] stringArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                String[] strings = stringArray[n2];
                logicalStructuresString.append(strings[0]).append('\u0000');
                logicalStructuresString.append(strings[1]).append('\u0000');
                ++n2;
            }
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        if (node != null) {
            node.put(PREF_JAVA_LOGICAL_STRUCTURES, logicalStructuresString.toString());
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                JDIDebugPlugin.log(e);
            }
        }
    }

    public static JavaLogicalStructure[] getJavaLogicalStructures() {
        JavaLogicalStructure[] logicalStructures = new JavaLogicalStructure[fPluginContributedJavaLogicalStructures.size() + fUserDefinedJavaLogicalStructures.size()];
        int i = 0;
        for (JavaLogicalStructure logicalStructure : fPluginContributedJavaLogicalStructures) {
            logicalStructures[i++] = logicalStructure;
        }
        for (JavaLogicalStructure logicalStructure : fUserDefinedJavaLogicalStructures) {
            logicalStructures[i++] = logicalStructure;
        }
        return logicalStructures;
    }

    public static void setUserDefinedJavaLogicalStructures(JavaLogicalStructure[] logicalStructures) {
        fUserDefinedJavaLogicalStructures = Arrays.asList(logicalStructures);
        JavaLogicalStructures.saveUserDefinedJavaLogicalStructures();
    }

    public static void addStructuresListener(IJavaStructuresListener listener) {
        fListeners.add(listener);
    }

    public static void removeStructuresListener(IJavaStructuresListener listener) {
        fListeners.remove(listener);
    }

    public ILogicalStructureType[] getLogicalStructureTypes(IValue value) {
        if (!(value instanceof IJavaObject)) {
            return new ILogicalStructureType[0];
        }
        IJavaObject javaValue = (IJavaObject)value;
        ArrayList<JavaLogicalStructure> logicalStructures = new ArrayList<JavaLogicalStructure>();
        try {
            IJavaInterfaceType[] superInterfaces;
            IJavaType type = javaValue.getJavaType();
            if (!(type instanceof IJavaClassType)) {
                return new ILogicalStructureType[0];
            }
            IJavaClassType classType = (IJavaClassType)type;
            List<JavaLogicalStructure> list = fJavaLogicalStructureMap.get(classType.getName());
            if (list != null) {
                logicalStructures.addAll(list);
            }
            IJavaClassType superClass = classType.getSuperclass();
            while (superClass != null) {
                this.addIfIsSubtype(logicalStructures, fJavaLogicalStructureMap.get(superClass.getName()));
                superClass = superClass.getSuperclass();
            }
            IJavaInterfaceType[] iJavaInterfaceTypeArray = superInterfaces = classType.getAllInterfaces();
            int n = superInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaInterfaceType superInterface = iJavaInterfaceTypeArray[n2];
                this.addIfIsSubtype(logicalStructures, fJavaLogicalStructureMap.get(superInterface.getName()));
                ++n2;
            }
        }
        catch (DebugException e) {
            JDIDebugPlugin.log(e);
            return new ILogicalStructureType[0];
        }
        return logicalStructures.toArray(new ILogicalStructureType[logicalStructures.size()]);
    }

    private void addIfIsSubtype(List<JavaLogicalStructure> logicalStructures, List<JavaLogicalStructure> list) {
        if (list == null) {
            return;
        }
        for (JavaLogicalStructure jls : list) {
            if (!jls.isSubtypes()) continue;
            logicalStructures.add(jls);
        }
    }

    static class PreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        PreferenceListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (PREF_JAVA_LOGICAL_STRUCTURES.equals(event.getKey())) {
                JavaLogicalStructures.initUserDefinedJavaLogicalStructures();
                JavaLogicalStructures.initJavaLogicalStructureMap();
                Iterator iter = fListeners.iterator();
                while (iter.hasNext()) {
                    ((IJavaStructuresListener)iter.next()).logicalStructuresChanged();
                }
            }
        }
    }
}

