/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.mpt.transformation;

import activity.Activity;
import activity.ActivitySet;
import activity.util.ActivityUtil;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import dispatching.ActivityDispatching;
import dispatching.Dispatch;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import machine.Import;
import machine.MachineFactory;
import machine.Resource;
import machine.ResourceItem;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.mpt.transformation.ExpandActivities;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public final class ReduceActivityDispatching {
    private ReduceActivityDispatching() {
    }

    public static void reduce(ActivityDispatching activityDispatching, ActivitySet activitySet) {
        HashSet allActivities = CollectionLiterals.newHashSet();
        EList _activities = activitySet.getActivities();
        Iterables.addAll((Collection)allActivities, (Iterable)_activities);
        Functions.Function1 _function = it -> it.getActivities();
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)activitySet.loadAll(), ActivitySet.class), (Functions.Function1)_function);
        Iterables.addAll((Collection)allActivities, (Iterable)_flatMap);
        LinkedHashMap<String, Activity> expandMap = ReduceActivityDispatching.expandNames(IterableExtensions.toList((Iterable)allActivities));
        Import importActivitySet = MachineFactory.eINSTANCE.createImport();
        importActivitySet.setImportURI(activitySet.eResource().getURI().toString());
        EList _imports = activityDispatching.getImports();
        _imports.add((Object)importActivitySet);
        Functions.Function1 _function_1 = it -> it.getDispatches();
        Consumer<Dispatch> _function_2 = dis -> {
            int _size_1;
            boolean _notEquals;
            Activity activity = (Activity)expandMap.get(dis.getActivity().getName());
            Collection itemNames = ActivityUtil.getItemNames((String)activity.getName(), (String)dis.getActivity().getName());
            EList resourceNeedingItem = activity.getResourcesNeedingItem();
            int _size = itemNames.size();
            boolean bl = _notEquals = _size != (_size_1 = resourceNeedingItem.size());
            if (_notEquals) {
                throw new RuntimeException("Cannot convert expanded activity");
            }
            Iterator iter = resourceNeedingItem.iterator();
            for (String itemName : itemNames) {
                Functions.Function1 _function_3 = it -> {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)itemName);
                };
                ResourceItem resourceItem = (ResourceItem)IterableExtensions.findFirst((Iterable)((Resource)iter.next()).getItems(), (Functions.Function1)_function_3);
                if (resourceItem == null) {
                    throw new RuntimeException("Cannot find item with name " + itemName);
                }
                EList _resourceItems = dis.getResourceItems();
                _resourceItems.add((Object)resourceItem);
            }
            dis.setActivity(activity);
        };
        IterableExtensions.flatMap((Iterable)activityDispatching.getDispatchGroups(), (Functions.Function1)_function_1).forEach(_function_2);
        EList _imports_1 = activityDispatching.getImports();
        _imports_1.remove((Object)importActivitySet);
        Functions.Function1 _function_3 = it -> it.getImportURI().contains(".activity");
        Import _findFirst = (Import)IterableExtensions.findFirst((Iterable)activityDispatching.getImports(), (Functions.Function1)_function_3);
        _findFirst.setImportURI(activitySet.eResource().getURI().toString());
    }

    private static LinkedHashMap<String, Activity> expandNames(List<Activity> activities) {
        return ExpandActivities.expandNames(activities);
    }
}

