/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.petri_net.util;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.lsat.petri_net.PetriNet;
import org.eclipse.lsat.petri_net.Place;
import org.eclipse.lsat.petri_net.Transition;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PetriNetEValidator
implements EValidator {
    public static final PetriNetEValidator INSTANCE = new PetriNetEValidator();

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePetriNet(PetriNet petriNet, DiagnosticChain diagnostics) {
        Set _set;
        boolean _notEquals;
        boolean result = true;
        Functions.Function1 _function = it -> it.getSubGraphs();
        Functions.Function1 _function_1 = it -> it.getNodes();
        Functions.Function1 _function_2 = it -> it.getIncomingEdges().isEmpty();
        Set calculatedInitial = IterableExtensions.toSet((Iterable)Queries.select((Iterable)Queries.xcollect((Iterable)Queries.closure(Collections.singleton(petriNet), (boolean)true, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        boolean bl = _notEquals = !Objects.equal((Object)calculatedInitial, (Object)(_set = IterableExtensions.toSet(petriNet.getInitialPlaces())));
        if (_notEquals) {
            return this.validationFailed(4, "Initial nodes are not aligned with reality", diagnostics, new EObject[]{petriNet});
        }
        return result;
    }

    public boolean validateTransitionIncoming(Transition transition, DiagnosticChain diagnostics) {
        boolean result = true;
        Functions.Function1 _function = it -> {
            Node _sourceNode = it.getSourceNode();
            return _sourceNode instanceof Place;
        };
        boolean conditionIsMet = IterableExtensions.forall((Iterable)transition.getIncomingEdges(), (Functions.Function1)_function);
        if (!conditionIsMet) {
            return this.validationFailed(4, "Transition should connect places", diagnostics, new EObject[]{transition});
        }
        return result;
    }

    public boolean validateTransitionOutgoing(Transition transition, DiagnosticChain diagnostics) {
        boolean result = true;
        Functions.Function1 _function = it -> {
            Node _targetNode = it.getTargetNode();
            return _targetNode instanceof Place;
        };
        boolean conditionIsMet = IterableExtensions.forall((Iterable)transition.getOutgoingEdges(), (Functions.Function1)_function);
        if (!conditionIsMet) {
            return this.validationFailed(4, "Transition should connect places", diagnostics, new EObject[]{transition});
        }
        return result;
    }

    public boolean validationFailed(int severity, String message, DiagnosticChain diagnostics, EObject ... data) {
        BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(severity, "org.eclipse.lsat.activity.dsl", 0, message, (Object[])data);
        diagnostics.add((Diagnostic)_basicDiagnostic);
        return false;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean _switchResult = false;
        int _classifierID = eClass.getClassifierID();
        switch (_classifierID) {
            case 0: {
                _switchResult = this.validatePetriNet((PetriNet)eObject, diagnostics);
                break;
            }
            case 2: {
                _switchResult = this.validateTransitionIncoming((Transition)eObject, diagnostics) && this.validateTransitionOutgoing((Transition)eObject, diagnostics);
                break;
            }
            case 1: {
                _switchResult = this.validateIncomingTransitionsPlace((Place)eObject, diagnostics) && this.validateOutgoingTransitionsPlace((Place)eObject, diagnostics);
                break;
            }
            default: {
                return true;
            }
        }
        return _switchResult;
    }

    public boolean validateOutgoingTransitionsPlace(Place place, DiagnosticChain diagnostics) {
        boolean result = true;
        Functions.Function1 _function = it -> {
            Node _targetNode = it.getTargetNode();
            return _targetNode instanceof Transition;
        };
        boolean conditionIsMet = IterableExtensions.forall((Iterable)place.getOutgoingEdges(), (Functions.Function1)_function);
        if (!conditionIsMet) {
            return this.validationFailed(4, "Place should be encapsulated by transitions", diagnostics, new EObject[]{place});
        }
        return result;
    }

    public boolean validateIncomingTransitionsPlace(Place place, DiagnosticChain diagnostics) {
        boolean result = true;
        Functions.Function1 _function = it -> {
            Node _sourceNode = it.getSourceNode();
            return _sourceNode instanceof Transition;
        };
        boolean conditionIsMet = IterableExtensions.forall((Iterable)place.getIncomingEdges(), (Functions.Function1)_function);
        if (!conditionIsMet) {
            return this.validationFailed(4, "Place should be encapsulated by transitions", diagnostics, new EObject[]{place});
        }
        return result;
    }
}

