/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.explorer.runtime.BaseState;
import org.eclipse.escet.cif.explorer.runtime.EventUsage;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.explorer.runtime.ExplorerEdge;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifAutomatonBuilder {
    private Map<Event, Event> evtMap = null;

    public Specification createAutomaton(Explorer expl, Specification oldSpec) {
        this.evtMap = Maps.map();
        Specification newSpec = CifConstructors.newSpecification();
        this.makeEventGroups((Group)oldSpec, (Group)newSpec);
        this.addAutomaton(expl, newSpec);
        this.evtMap = null;
        return newSpec;
    }

    private boolean makeEventGroups(Group oldGrp, Group newGrp) {
        boolean nonEmpty = false;
        for (Component comp : oldGrp.getComponents()) {
            Group subGrp;
            if (comp instanceof Group) {
                Group oldComp = (Group)comp;
                subGrp = CifConstructors.newGroup();
                subGrp.setName(oldComp.getName());
                if (this.makeEventGroups(oldComp, subGrp)) {
                    newGrp.getComponents().add((Object)subGrp);
                    nonEmpty = true;
                }
            }
            if (!(comp instanceof Automaton)) continue;
            Automaton oldAut = (Automaton)comp;
            subGrp = CifConstructors.newGroup();
            subGrp.setName(oldAut.getName());
            if (!this.addEvents(subGrp, (List<Declaration>)oldAut.getDeclarations())) continue;
            newGrp.getComponents().add((Object)subGrp);
            nonEmpty = true;
        }
        return nonEmpty |= this.addEvents(newGrp, (List<Declaration>)oldGrp.getDeclarations());
    }

    private boolean addEvents(Group grp, List<Declaration> decls) {
        boolean nonEmpty = false;
        for (Declaration decl : decls) {
            if (!(decl instanceof Event)) continue;
            Event oldEvent = (Event)decl;
            Boolean ctl = oldEvent.getControllable();
            Event newEvent = CifConstructors.newEvent((Boolean)ctl, (String)oldEvent.getName(), null, null);
            grp.getDeclarations().add((Object)newEvent);
            this.evtMap.put(oldEvent, newEvent);
            nonEmpty = true;
        }
        return nonEmpty;
    }

    private static String makeNewName(String name, Specification spec) {
        Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
        if (names.contains(name)) {
            name = CifScopeUtils.getUniqueName((String)name, (Set)names, (Set)names);
        }
        return name;
    }

    private void addAutomaton(Explorer expl, Specification newSpec) {
        Automaton aut = CifConstructors.newAutomaton();
        aut.setName(CifAutomatonBuilder.makeNewName("statespace", newSpec));
        newSpec.getComponents().add((Object)aut);
        Alphabet alphabet = CifConstructors.newAlphabet();
        aut.setAlphabet(alphabet);
        for (EventUsage evtUse : expl.eventUsages) {
            Event evt = this.evtMap.get(evtUse.event);
            EventExpression ee = CifConstructors.newEventExpression((Event)evt, null, (CifType)CifConstructors.newBoolType());
            alphabet.getEvents().add((Object)ee);
        }
        if (expl.states == null || expl.states.isEmpty()) {
            Location loc = CifConstructors.newLocation();
            aut.getLocations().add((Object)loc);
            return;
        }
        int idx = 0;
        for (BaseState state : expl.states.values()) {
            Assert.check((state.stateNumber == idx + 1 ? 1 : 0) != 0);
            Location loc = CifConstructors.newLocation();
            loc.setName(Strings.fmt((String)"loc%d", (Object[])new Object[]{idx + 1}));
            if (state.isInitial()) {
                loc.getInitials().add((Object)CifValueUtils.makeTrue());
            }
            if (state.isMarked()) {
                loc.getMarkeds().add((Object)CifValueUtils.makeTrue());
            }
            aut.getLocations().add((Object)loc);
            ++idx;
        }
        idx = 0;
        for (BaseState state : expl.states.values()) {
            Location srcLoc = (Location)aut.getLocations().get(idx++);
            for (ExplorerEdge explEdge : state.getOutgoingEdges()) {
                Location dstLoc = (Location)aut.getLocations().get(explEdge.next.stateNumber - 1);
                Edge edge = CifConstructors.newEdge();
                if (srcLoc != dstLoc) {
                    edge.setTarget(dstLoc);
                }
                srcLoc.getEdges().add((Object)edge);
                if (explEdge.event == null) continue;
                Event newEvent = this.evtMap.get(explEdge.event);
                EventExpression e = CifConstructors.newEventExpression((Event)newEvent, null, (CifType)CifConstructors.newBoolType());
                EdgeEvent ee = CifConstructors.newEdgeEvent();
                ee.setEvent((Expression)e);
                edge.getEvents().add((Object)ee);
            }
        }
    }
}

