/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.lsat.common.ludus.backend.games.GameGraph;

public class Serializer {
    private Serializer() {
    }

    public static <V, E> String serialize(GameGraph<V, E> graph, String fileName) throws IOException {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd-hh.mm.ss").format(new Date());
        String outputName = String.valueOf(fileName) + "_" + timeStamp;
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputName));
        out.writeObject(graph);
        out.close();
        return outputName;
    }

    public static GameGraph<?, ?> load(String fileName) throws IOException, ClassNotFoundException {
        System.out.println(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));
        GameGraph restoredGraph = (GameGraph)in.readObject();
        in.close();
        return restoredGraph;
    }
}

