/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;

public abstract class AutoVarOrderer {
    protected boolean dbgEnabled;
    protected int varCnt;
    protected int[] curIndices;
    protected int[] newIndices;
    protected int[] bestIndices;
    protected BitSet[] edges;

    public boolean order(SynthesisAutomaton aut, List<BitSet> edges, boolean dbgEnabled) {
        boolean initialized;
        if (aut.variables.length < 2) {
            return false;
        }
        this.dbgEnabled = dbgEnabled;
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Applying automatic variable ordering:");
        }
        if (initialized = this.initializeCommon(aut, edges)) {
            this.initializeAlgo();
        }
        if (initialized) {
            this.computeOrder();
        }
        boolean reordered = false;
        if (initialized) {
            reordered = this.reorder(aut);
        }
        this.cleanupAlgo();
        this.cleanupCommon();
        return reordered;
    }

    private boolean initializeCommon(SynthesisAutomaton aut, List<BitSet> hyperEdges) {
        this.varCnt = aut.variables.length;
        this.curIndices = new int[this.varCnt];
        int i = 0;
        while (i < this.varCnt) {
            this.curIndices[i] = i;
            ++i;
        }
        this.newIndices = new int[this.varCnt];
        System.arraycopy(this.curIndices, 0, this.newIndices, 0, this.varCnt);
        this.bestIndices = new int[this.varCnt];
        System.arraycopy(this.curIndices, 0, this.bestIndices, 0, this.varCnt);
        this.edges = hyperEdges.toArray(new BitSet[hyperEdges.size()]);
        hyperEdges.clear();
        BitSet[] bitSetArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet edge = bitSetArray[n2];
            Assert.check((!edge.isEmpty() ? 1 : 0) != 0);
            ++n2;
        }
        if (this.dbgEnabled) {
            OutputProvider.dbg((String)"  Number of hyperedges: %,d", (Object[])new Object[]{this.edges.length});
        }
        if (this.edges.length == 0) {
            if (this.dbgEnabled) {
                OutputProvider.dbg();
                OutputProvider.dbg((String)"  Skipping automatic ordering: no hyperedges.");
            }
            return false;
        }
        return true;
    }

    protected abstract void initializeAlgo();

    protected abstract void computeOrder();

    protected long computeTotalSpan(int[] indices) {
        long totalSpan = 0L;
        int i = 0;
        while (i < this.edges.length) {
            BitSet edge = this.edges[i];
            int minIdx = Integer.MAX_VALUE;
            int maxIdx = 0;
            int j = 0;
            while (j < this.varCnt) {
                if (edge.get(j)) {
                    int idx = indices[j];
                    minIdx = Math.min(minIdx, idx);
                    maxIdx = Math.max(maxIdx, idx);
                }
                ++j;
            }
            int span = maxIdx - minIdx;
            totalSpan += (long)span;
            ++i;
        }
        return totalSpan;
    }

    private boolean reorder(SynthesisAutomaton aut) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(this.curIndices, this.bestIndices);
        if (this.dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"  Variable order %schanged.", (Object[])new Object[]{changed ? "" : "un"});
        }
        if (changed) {
            SynthesisVariable[] newVars = new SynthesisVariable[this.varCnt];
            int varIdx = 0;
            while (varIdx < this.varCnt) {
                int orderIdx = this.bestIndices[varIdx];
                SynthesisVariable var = aut.variables[varIdx];
                var.group = orderIdx;
                newVars[orderIdx] = var;
                ++varIdx;
            }
            aut.variables = newVars;
        }
        return changed;
    }

    private void cleanupCommon() {
        this.varCnt = -1;
        this.curIndices = null;
        this.newIndices = null;
        this.bestIndices = null;
        this.edges = null;
    }

    protected abstract void cleanupAlgo();
}

