/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.common.ui.dialogs.PopupDialog;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ElementTypeLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.InternalDiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.dialogs.AbstractSelectElementDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class CreateOrSelectElementCommand
extends PopupMenuCommand {
    public static final String UNSPECIFIED = InternalDiagramUIMessages.CreateOrSelectElementCommand_PopupMenu_UnspecifiedMenuItem_Text;
    public static final String SELECT_EXISTING = InternalDiagramUIMessages.CreateOrSelectElementCommand_PopupMenu_SelectExistingElementMenuItem_Text;
    public static final String CREATE_WITHOUT_BINDING = InternalDiagramUIMessages.CreateOrSelectElementCommand_PopupMenu_CreateWithoutBindingMenuItem_Text;
    private ObjectAdapter resultAdapter = new ObjectAdapter();
    private AbstractSelectElementDialog selectElementDialog;

    public CreateOrSelectElementCommand(Shell parentShell, List content) {
        this(parentShell, content, 1);
    }

    public CreateOrSelectElementCommand(Shell parentShell, List content, int style) {
        this(InternalDiagramUIMessages.CreateOrSelectElementCommand_Label, parentShell, content, style);
    }

    public CreateOrSelectElementCommand(String label, Shell parentShell, List content) {
        this(label, parentShell, content, 1);
    }

    public CreateOrSelectElementCommand(String label, Shell parentShell, List content, int style) {
        super(label, parentShell);
        if (style == 2) {
            this.setPopupDialog(new PopupDialog(parentShell, content, this.getLabelProvider()));
        } else {
            this.setPopupMenu(new PopupMenu(content, this.getLabelProvider()));
        }
    }

    public CreateOrSelectElementCommand(Shell parentShell, PopupMenu popupMenu) {
        super(InternalDiagramUIMessages.CreateOrSelectElementCommand_Label, parentShell, popupMenu);
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
        if (!cmdResult.getStatus().isOK()) {
            return cmdResult;
        }
        Object result = cmdResult.getReturnValue();
        if (result != null) {
            if (result.equals(SELECT_EXISTING)) {
                AbstractSelectElementDialog dialog = this.getSelectElementDialog();
                Assert.isNotNull((Object)dialog);
                if (dialog.open() != 0) {
                    return CommandResult.newCancelledCommandResult();
                }
                List selectedElements = dialog.getSelectedElements();
                if (selectedElements == null) {
                    progressMonitor.setCanceled(true);
                    return CommandResult.newCancelledCommandResult();
                }
                if (dialog.isMultiSelectable()) {
                    this.resultAdapter.setObject((Object)selectedElements);
                    return CommandResult.newOKCommandResult((Object)selectedElements);
                }
                this.resultAdapter.setObject(selectedElements.get(0));
                return CommandResult.newOKCommandResult(selectedElements.get(0));
            }
            this.resultAdapter.setObject(result);
        }
        return cmdResult;
    }

    protected AbstractSelectElementDialog getSelectElementDialog() {
        return this.selectElementDialog;
    }

    public void setSelectElementDialog(AbstractSelectElementDialog dialog) {
        this.selectElementDialog = dialog;
    }

    public ObjectAdapter getResultAdapter() {
        return this.resultAdapter;
    }

    protected ILabelProvider getLabelProvider() {
        return new LabelProvider();
    }

    public static class LabelProvider
    extends ElementTypeLabelProvider {
        @Override
        public String getText(Object object) {
            String text = super.getText(object);
            if (object instanceof IElementType) {
                return NLS.bind((String)InternalDiagramUIMessages.CreateOrSelectElementCommand_PopupMenu_CreateMenuItem_Text, (Object)text);
            }
            return text;
        }
    }
}

