/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.scoping

import activity.LocationPrerequisite
import activity.PeripheralAction
import activity.ResourceAction
import org.eclipse.emf.ecore.EReference
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it 
 *
 */
class ActivityScopeProvider extends AbstractDeclarativeScopeProvider {
//    If you want to log the queried scoping rules, just enable this error handler
//    new() {
//        errorHandler = new PolymorphicDispatcher.ErrorHandler<IScope> {
//            override handle(Object[] params, Throwable throwable) {
//                System.err.println(throwable.message)
//                return null
//            }
//        }
//    }
	
    /**
     * Scoping for location prerequisites
     */
 
    def IScope scope_Peripheral(LocationPrerequisite prerequisite, EReference ref) {
        if(null === prerequisite.resource){
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(prerequisite.resource.resource.peripherals.filter[!it.positions.isEmpty])
    }

    def IScope scope_SymbolicPosition(LocationPrerequisite prerequisite, EReference ref) {
        if(null === prerequisite.peripheral){
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(prerequisite.peripheral.positions)
    }

    /**
     * Scoping for node tree
     */
    def IScope scope_Node(EditableDirectedGraph graph, EReference ref) {
      if(null === graph.nodes){
          return IScope.NULLSCOPE
      }
      return Scopes.scopeFor(graph.nodes)
    }

    def IScope scope_Peripheral(ResourceAction action, EReference ref) {
        if(null === action.resource){
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(action.resource.resource.peripherals)
    }

	def IScope scope_ActionType(PeripheralAction action, EReference ref) {
        if(null === action.peripheral){
            return IScope.NULLSCOPE
        }
		return Scopes.scopeFor(action.peripheral.type.actions)
	}

    def IScope scope_SymbolicPosition(PeripheralAction action, EReference ref) {
        if(null === action.peripheral){
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(action.peripheral.positions)
    }

    def IScope scope_Distance(PeripheralAction action, EReference ref) {
        if(null === action.peripheral){
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(action.peripheral.distances)
    }
    
    def IScope scope_Profile(PeripheralAction action, EReference ref) {
        if(null === action.peripheral){
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(action.peripheral.profiles)
    }


}
