/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.graph.directed.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.Node;

public final class DirectedGraphUtil {
    private DirectedGraphUtil() {
    }

    public static void addEdge(DirectedGraph<? extends Node, ? extends Edge> graph, Node source, Node target, EdgeFactory factory) {
        if (!DirectedGraphUtil.edgeExists(graph, source, target)) {
            Edge edge = factory.create();
            edge.setSourceNode(source);
            edge.setTargetNode(target);
            edge.setGraph(graph);
        }
    }

    public static void delete(Node node) {
        for (Edge edge : node.getIncomingEdges()) {
            DirectedGraphUtil.delete(edge);
        }
        for (Edge edge : node.getOutgoingEdges()) {
            DirectedGraphUtil.delete(edge);
        }
        EcoreUtil.delete((EObject)node);
    }

    public static void delete(Edge edge) {
        edge.setSourceNode(null);
        edge.setTargetNode(null);
        EcoreUtil.delete((EObject)edge);
    }

    public static void shortcutAndRemoveNode(Node node, EdgeFactory edgeFactory) {
        DirectedGraph graph = (DirectedGraph)node.eContainer();
        for (Edge in : node.getIncomingEdges()) {
            for (Edge out : node.getOutgoingEdges()) {
                DirectedGraphUtil.addEdge(graph, in.getSourceNode(), out.getTargetNode(), edgeFactory);
            }
        }
        new ArrayList<Edge>((Collection<Edge>)node.getIncomingEdges()).forEach(e -> DirectedGraphUtil.delete(e));
        new ArrayList<Edge>((Collection<Edge>)node.getOutgoingEdges()).forEach(e -> DirectedGraphUtil.delete(e));
        DirectedGraphUtil.delete(node);
    }

    private static boolean edgeExists(DirectedGraph<? extends Node, ? extends Edge> graph, Node source, Node target) {
        return graph.getEdges().stream().anyMatch(e -> e.getSourceNode() == source && e.getTargetNode() == target);
    }

    public static interface EdgeFactory {
        public Edge create();
    }
}

