/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.teditor;

import activity.ActivityFactory;
import activity.SyncBar;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.lib.Extension;

public class ActivityLinkingService
extends DefaultLinkingService {
    @Inject
    @Extension
    private ActivityGrammarAccess activityGrammarAccess;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode inode) throws IllegalNodeException {
        EObject singleResult;
        List<EObject> result = super.getLinkedObjects(context, ref, inode);
        EObject eObject = singleResult = result == null || result.isEmpty() ? null : (EObject)result.get(0);
        if (inode.getGrammarElement().equals(this.activityGrammarAccess.getSourceReferenceAccess().getNodeSyncBarCrossReference_1_1_1_0()) || inode.getGrammarElement().equals(this.activityGrammarAccess.getTargetReferenceAccess().getNodeSyncBarCrossReference_1_1_1_0())) {
            if (singleResult == null) {
                EObject syncBar = this.createSyncBar((Edge)context.eContainer(), inode.getText().trim());
                result = Collections.singletonList(syncBar);
            } else if (!(singleResult instanceof SyncBar)) {
                throw new IllegalNodeException(inode, String.format("Cannot create sync bar, an action with name %s already exitsts", inode.getText().trim()));
            }
        } else if ((inode.getGrammarElement().equals(this.activityGrammarAccess.getSourceReferenceAccess().getNodeActionCrossReference_1_0_0()) || inode.getGrammarElement().equals(this.activityGrammarAccess.getTargetReferenceAccess().getNodeActionCrossReference_1_0_0())) && singleResult instanceof SyncBar) {
            throw new IllegalNodeException(inode, String.format("Reference to sync bar %s should be preceded with the '|' sign", inode.getText().trim()));
        }
        return result;
    }

    private EObject createSyncBar(Edge context, String name) {
        EditableDirectedGraph graph = context.getGraph();
        if (graph == null) {
            return null;
        }
        SyncBar syncBar = ActivityFactory.eINSTANCE.createSyncBar();
        syncBar.setName(name);
        graph.getNodes().add((Object)syncBar);
        return syncBar;
    }
}

