/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.calculator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsat.motioncalculator.MotionCalculator;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.motioncalculator.MotionSegment;
import org.eclipse.lsat.motioncalculator.MotionSetPoint;
import org.eclipse.lsat.motioncalculator.MotionValidationException;
import org.eclipse.lsat.motioncalculator.PositionInfo;
import org.eclipse.lsat.motioncalculator.util.MotionSegmentUtilities;
import org.eclipse.lsat.motioncalculator.util.MotionSetPointUtilities;

public class PointToPointMotionCalculator
implements MotionCalculator {
    public static final String ID = "org.eclipse.lsat.timing.calculator.PointToPointMotionCalculator";
    protected static final String THIRD_ORDER_POINT_TO_POINT_MOTION_PROFILE_KEY = "ThirdOrderP2P";
    protected static final String VELOCITY_PARAMETER_KEY = "V";
    protected static final String ACCELERATION_PARAMETER_KEY = "A";
    protected static final String JERK_PARAMETER_KEY = "J";
    protected static final String SETTLING_PARAMETER_KEY = "S";
    private static final double DEFAULT_SAMPLE_FREQUENCY = 5000.0;
    private static final double DZERO = BigDecimal.ZERO.doubleValue();

    public void validate(List<MotionSegment> segments) throws MotionValidationException {
        if (segments.size() == 0) {
            throw new MotionValidationException("Programming error: expected at least 1 motion segment. Please contact LSAT support.", new MotionSegment[0]);
        }
        for (String setPoint : MotionSegmentUtilities.getSetPointIds(segments)) {
            List motionSetPoints = MotionSegmentUtilities.getMotionSetPoints(segments, (String)setPoint);
            if (motionSetPoints.stream().anyMatch(MotionSetPoint::doesMove) && !motionSetPoints.stream().allMatch(MotionSetPoint::doesMove)) {
                List eroneousSegments = segments.stream().filter(s -> !s.getMotionSetpoint(setPoint).doesMove()).collect(Collectors.toList());
                throw new MotionValidationException(String.format("Setpoint %s does not move during this part of the concatenated %s", setPoint, String.join((CharSequence)", ", segments.stream().map(Object::toString).collect(Collectors.toList()))), eroneousSegments);
            }
            Set motionProfiles = MotionSetPointUtilities.getMotionProfiles((Collection)motionSetPoints);
            if (motionProfiles.size() > 1) {
                throw new MotionValidationException("A concatenated point-to-point move should use the same motion profile", segments);
            }
            Map motionProfileArguments = ((MotionSetPoint)motionSetPoints.get(0)).getMotionProfileArguments();
            if (motionSetPoints.stream().allMatch(s -> s.getMotionProfileArguments().equals(motionProfileArguments))) continue;
            throw new MotionValidationException("A concatenated point-to-point move should define the same motion profile arguments", segments);
        }
    }

    public Collection<PositionInfo> getPositionInfo(List<MotionSegment> segments) throws MotionException {
        Set setPointIds = MotionSegmentUtilities.getSetPointIds(segments);
        if (setPointIds.isEmpty()) {
            return Collections.emptySet();
        }
        Double pointToPointTime = this.calculatePointToPointTime(segments);
        ArrayList<PositionInfo> result = new ArrayList<PositionInfo>();
        for (String setPointId : setPointIds) {
            List setPoints = MotionSegmentUtilities.getMotionSetPoints(segments, (String)setPointId);
            double[][] samples = this.sampleMotionProfile(setPoints, pointToPointTime);
            PositionInfo positionInfo = new PositionInfo(setPointId);
            double[][] dArray = samples;
            int n = samples.length;
            int n2 = 0;
            while (n2 < n) {
                double[] sample = dArray[n2];
                positionInfo.addTimePosition(sample[0], sample[1]);
                ++n2;
            }
            result.add(positionInfo);
        }
        return Collections.unmodifiableCollection(result);
    }

    public List<Double> calculateTimes(List<MotionSegment> segments) throws MotionException {
        Double pointToPointTime;
        if (segments.get(0).getMotionSetpoints().isEmpty()) {
            return Collections.emptyList();
        }
        Double[] motionTimes = new Double[segments.size()];
        motionTimes[motionTimes.length - 1] = pointToPointTime = this.calculatePointToPointTime(segments);
        if (segments.size() == 1) {
            return Arrays.asList(motionTimes);
        }
        for (String setPointId : MotionSegmentUtilities.getSetPointIds(segments)) {
            List setPoints = MotionSegmentUtilities.getMotionSetPoints(segments, (String)setPointId);
            double[][] samples = this.sampleMotionProfile(setPoints, pointToPointTime);
            int index = 0;
            while (index < segments.size() - 1) {
                BigDecimal to = MotionSetPointUtilities.getTo(setPoints.subList(0, index + 1));
                Double setPointTime = this.determineTimeforLocation(to, samples);
                if (setPointTime == null) {
                    BigDecimal startPos = MotionSetPointUtilities.getFrom((List)setPoints);
                    BigDecimal endPos = MotionSetPointUtilities.getTo((List)setPoints);
                    throw new MotionException(String.format("Cannot find location for setpoint %s: %f not between %f and %f", setPointId, to, startPos, endPos));
                }
                double currentTime = motionTimes[index] == null ? 0.0 : motionTimes[index];
                motionTimes[index] = Math.max(currentTime, Math.min(setPointTime, pointToPointTime));
                ++index;
            }
        }
        return Arrays.asList(motionTimes);
    }

    private Double calculatePointToPointTime(List<MotionSegment> segments) throws MotionException {
        HashMap<String, Double> pointToPointTime = new HashMap<String, Double>();
        for (String setPointId : MotionSegmentUtilities.getSetPointIds(segments)) {
            List setPoints = MotionSegmentUtilities.getMotionSetPoints(segments, (String)setPointId);
            Double spTime = this.calculateTime(setPoints);
            pointToPointTime.put(setPointId, spTime);
        }
        return (Double)Collections.max(pointToPointTime.values());
    }

    private Double calculateTime(List<MotionSetPoint> setPoints) throws MotionException {
        MotionSetPoint lastSp = setPoints.get(setPoints.size() - 1);
        double vMax = this.toPositiveDouble(lastSp.getMotionProfileArgument(VELOCITY_PARAMETER_KEY));
        double aMax = this.toPositiveDouble(lastSp.getMotionProfileArgument(ACCELERATION_PARAMETER_KEY));
        double jMax = this.toPositiveDouble(lastSp.getMotionProfileArgument(JERK_PARAMETER_KEY));
        double tSettle = this.toPositiveDouble(lastSp.isSettling() ? lastSp.getMotionProfileArgument(SETTLING_PARAMETER_KEY, BigDecimal.ZERO) : BigDecimal.ZERO);
        double sAbs = MotionSetPointUtilities.getDistance(setPoints).abs().doubleValue();
        double[] t_vaj = this.calculateTvTaTj(sAbs, vMax, aMax, jMax);
        return t_vaj[0] + 2.0 * t_vaj[1] + 4.0 * t_vaj[2] + tSettle;
    }

    private double[][] sampleMotionProfile(List<MotionSetPoint> setPoints, Double stretchToTime) throws MotionException {
        double tj;
        BigDecimal to;
        MotionSetPoint lastSp = setPoints.get(setPoints.size() - 1);
        double vMax = this.toPositiveDouble(lastSp.getMotionProfileArgument(VELOCITY_PARAMETER_KEY));
        double aMax = this.toPositiveDouble(lastSp.getMotionProfileArgument(ACCELERATION_PARAMETER_KEY));
        double jMax = this.toPositiveDouble(lastSp.getMotionProfileArgument(JERK_PARAMETER_KEY));
        double tSettle = this.toPositiveDouble(lastSp.isSettling() ? lastSp.getMotionProfileArgument(SETTLING_PARAMETER_KEY, BigDecimal.ZERO) : BigDecimal.ZERO);
        BigDecimal distance = MotionSetPointUtilities.getDistance(setPoints);
        BigDecimal from = MotionSetPointUtilities.getFrom(setPoints);
        if (from.compareTo(to = MotionSetPointUtilities.getTo(setPoints)) == 0) {
            double[][] dArrayArray;
            if (stretchToTime == null) {
                double[][] dArrayArray2 = new double[2][];
                dArrayArray2[0] = new double[]{DZERO, from.doubleValue(), DZERO, DZERO, DZERO};
                dArrayArray = dArrayArray2;
                dArrayArray2[1] = new double[]{tSettle, to.doubleValue(), DZERO, DZERO, DZERO};
            } else {
                double[][] dArrayArray3 = new double[2][];
                dArrayArray3[0] = new double[]{DZERO, from.doubleValue()};
                dArrayArray = dArrayArray3;
                dArrayArray3[1] = new double[]{stretchToTime, to.doubleValue()};
            }
            return dArrayArray;
        }
        double sFrom = from.doubleValue();
        double sTo = to.doubleValue();
        double sAbs = distance.abs().doubleValue();
        double[] t_vaj = this.calculateTvTaTj(sAbs, vMax, aMax, jMax);
        double tv = t_vaj[0];
        double ta = t_vaj[1];
        double t1 = tj = t_vaj[2];
        double t2 = t1 + ta;
        double t3 = t2 + tj;
        double t4 = t3 + tv;
        double t5 = t4 + tj;
        double t6 = t5 + ta;
        double t7 = t6 + tj;
        jMax = sTo < sFrom ? -jMax : jMax;
        double a1 = jMax * tj;
        double v1 = 0.5 * jMax * Math.pow(tj, 2.0);
        double p1 = sFrom + jMax * Math.pow(tj, 3.0) / 6.0;
        double a2 = a1;
        double v2 = v1 + a1 * ta;
        double p2 = p1 + v1 * ta + 0.5 * a1 * Math.pow(ta, 2.0);
        double a3 = 0.0;
        double v3 = v2 + a2 * tj - 0.5 * jMax * Math.pow(tj, 2.0);
        double p3 = p2 + v2 * tj + 0.5 * a2 * Math.pow(tj, 2.0) - jMax * Math.pow(tj, 3.0) / 6.0;
        double a4 = 0.0;
        double v4 = v3;
        double p4 = p3 + v3 * tv;
        double a5 = -jMax * tj;
        double v5 = v4 - 0.5 * jMax * Math.pow(tj, 2.0);
        double p5 = p4 + v4 * tj - jMax * Math.pow(tj, 3.0) / 6.0;
        double a6 = a5;
        double v6 = v5 + a5 * ta;
        double p6 = p5 + v5 * ta + 0.5 * a5 * Math.pow(ta, 2.0);
        double a7 = 0.0;
        double v7 = 0.0;
        double p7 = sTo;
        double point2pointTime = t7 + tSettle;
        boolean stretch = stretchToTime != null && Double.compare(stretchToTime, point2pointTime) != 0;
        double stretchFactor = stretch ? stretchToTime / point2pointTime : 1.0;
        int tpvaj_size = (int)Math.ceil(point2pointTime * 5000.0) + 1;
        double[][] tpvaj = new double[tpvaj_size][stretch ? 2 : 5];
        int index = 0;
        double t = 0.0;
        if (index < tpvaj_size) {
            do {
                tpvaj[index][0] = t * stretchFactor;
                tpvaj[index][1] = sFrom + jMax * Math.pow(t, 3.0) / 6.0;
                if (stretch) continue;
                tpvaj[index][2] = 0.5 * jMax * Math.pow(t, 2.0);
                tpvaj[index][3] = jMax * t;
                tpvaj[index][4] = jMax;
            } while ((t = (double)(++index) / 5000.0) < t1);
        }
        if (index < tpvaj_size) {
            do {
                tpvaj[index][0] = t * stretchFactor;
                tpvaj[index][1] = p1 + v1 * (t - t1) + 0.5 * a1 * Math.pow(t - t1, 2.0);
                if (stretch) continue;
                tpvaj[index][2] = v1 + a1 * (t - t1);
                tpvaj[index][3] = a1;
                tpvaj[index][4] = 0.0;
            } while ((t = (double)(++index) / 5000.0) < t2);
        }
        if (index < tpvaj_size) {
            do {
                tpvaj[index][0] = t * stretchFactor;
                tpvaj[index][1] = p2 + v2 * (t - t2) + 0.5 * a2 * Math.pow(t - t2, 2.0) - jMax * Math.pow(t - t2, 3.0) / 6.0;
                if (stretch) continue;
                tpvaj[index][2] = v2 + a2 * (t - t2) - 0.5 * jMax * Math.pow(t - t2, 2.0);
                tpvaj[index][3] = a2 - jMax * (t - t2);
                tpvaj[index][4] = -jMax;
            } while ((t = (double)(++index) / 5000.0) < t3);
        }
        if (index < tpvaj_size) {
            do {
                tpvaj[index][0] = t * stretchFactor;
                tpvaj[index][1] = p3 + v3 * (t - t3);
                if (stretch) continue;
                tpvaj[index][2] = v3;
                tpvaj[index][3] = 0.0;
                tpvaj[index][4] = 0.0;
            } while ((t = (double)(++index) / 5000.0) < t4);
        }
        if (index < tpvaj_size) {
            do {
                tpvaj[index][0] = t * stretchFactor;
                tpvaj[index][1] = p4 + v4 * (t - t4) - jMax * Math.pow(t - t4, 3.0) / 6.0;
                if (stretch) continue;
                tpvaj[index][2] = v4 - 0.5 * jMax * Math.pow(t - t4, 2.0);
                tpvaj[index][3] = -jMax * (t - t4);
                tpvaj[index][4] = -jMax;
            } while ((t = (double)(++index) / 5000.0) < t5);
        }
        if (index < tpvaj_size) {
            do {
                tpvaj[index][0] = t * stretchFactor;
                tpvaj[index][1] = p5 + v5 * (t - t5) + 0.5 * a5 * Math.pow(t - t5, 2.0);
                if (stretch) continue;
                tpvaj[index][2] = v5 + a5 * (t - t5);
                tpvaj[index][3] = a5;
                tpvaj[index][4] = 0.0;
            } while ((t = (double)(++index) / 5000.0) < t6);
        }
        if (index < tpvaj_size) {
            do {
                tpvaj[index][0] = t * stretchFactor;
                tpvaj[index][1] = p6 + v6 * (t - t6) + 0.5 * a6 * Math.pow(t - t6, 2.0) + jMax * Math.pow(t - t6, 3.0) / 6.0;
                if (stretch) continue;
                tpvaj[index][2] = v6 + a6 * (t - t6) + 0.5 * jMax * Math.pow(t - t6, 2.0);
                tpvaj[index][3] = a6 + jMax * (t - t6);
                tpvaj[index][4] = jMax;
            } while ((t = (double)(++index) / 5000.0) < t7);
        }
        while (index < tpvaj.length) {
            tpvaj[index][0] = t * stretchFactor;
            tpvaj[index][1] = p7;
            if (!stretch) {
                tpvaj[index][2] = 0.0;
                tpvaj[index][3] = 0.0;
                tpvaj[index][4] = 0.0;
            }
            t = (double)(++index) / 5000.0;
        }
        return tpvaj;
    }

    private Double determineTimeforLocation(BigDecimal location, double[][] tpvaj) {
        double locationD = location.doubleValue();
        int operator = Double.compare(locationD, tpvaj[0][1]);
        if (operator == 0) {
            return tpvaj[0][0];
        }
        int index = 0;
        while (index < tpvaj.length && Double.compare(locationD, tpvaj[index][1]) == operator) {
            ++index;
        }
        if (index < 1 || index >= tpvaj.length) {
            return null;
        }
        double timFrom = tpvaj[index - 1][0];
        double locFrom = tpvaj[index - 1][1];
        double timTo = tpvaj[index][0];
        double locTo = tpvaj[index][1];
        double factor = (locationD - locFrom) / (locTo - locFrom);
        double time = timFrom + factor * (timTo - timFrom);
        return time;
    }

    private double[] calculateTvTaTj(double sAbs, double vMax, double aMax, double jMax) {
        double[] t_vaj = new double[3];
        if (aMax < Math.sqrt(vMax * jMax)) {
            if (sAbs > Math.pow(vMax, 2.0) / aMax + vMax * aMax / jMax) {
                t_vaj[2] = aMax / jMax;
                t_vaj[1] = vMax / aMax - aMax / jMax;
                t_vaj[0] = sAbs / vMax - vMax / aMax - aMax / jMax;
            } else if (sAbs > 2.0 * Math.pow(aMax, 3.0) / Math.pow(jMax, 2.0)) {
                t_vaj[2] = aMax / jMax;
                t_vaj[1] = -(3.0 * aMax) / (2.0 * jMax) + Math.sqrt(Math.pow(aMax, 2.0) / (4.0 * Math.pow(jMax, 2.0)) + sAbs / aMax);
                t_vaj[0] = 0.0;
            } else {
                t_vaj[2] = Math.pow(sAbs / (2.0 * jMax), 0.3333333333333333);
                t_vaj[1] = 0.0;
                t_vaj[0] = 0.0;
            }
        } else if (aMax >= Math.sqrt(vMax * jMax)) {
            if (sAbs < 2.0 * Math.sqrt(Math.pow(vMax, 3.0) / jMax)) {
                t_vaj[2] = Math.pow(sAbs / (2.0 * jMax), 0.3333333333333333);
                t_vaj[1] = 0.0;
                t_vaj[0] = 0.0;
            } else {
                t_vaj[2] = Math.sqrt(vMax / jMax);
                t_vaj[1] = 0.0;
                t_vaj[0] = sAbs / vMax - 2.0 * Math.sqrt(vMax / jMax);
            }
        }
        return t_vaj;
    }

    private double toPositiveDouble(BigDecimal bd) throws MotionException {
        if (bd == null) {
            throw new MotionException("Value cannot be null");
        }
        if (bd.compareTo(BigDecimal.ZERO) < 0) {
            throw new MotionException("Value should be greater then zero: " + String.valueOf(bd));
        }
        return bd.doubleValue();
    }
}

