/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.qvto.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsat.common.qvto.util.AbstractModelTransformer;
import org.eclipse.lsat.common.qvto.util.ExecutionDiagnosticException;
import org.eclipse.lsat.common.qvto.util.QvtoErrorStatusException;
import org.eclipse.lsat.common.qvto.util.QvtoTransformationException;
import org.eclipse.lsat.common.qvto.util.internal.StatusLogger;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;

public abstract class AbstractModelTransformerWithStatus<Input, Output>
extends AbstractModelTransformer<Input, Output> {
    private MultiStatus status = null;

    public IStatus getStatus() {
        if (this.status == null) {
            throw new IllegalStateException("Transformation should be started before querying its status.");
        }
        return this.status;
    }

    protected String getPluginID() {
        URI uri = this.getTransformationURI();
        if (uri.isPlatform() && uri.segmentCount() > 1) {
            return uri.segment(0);
        }
        return "org.eclipse.lsat.common.qvto.util";
    }

    @Override
    protected void execute(ModelExtent ... aModelParameters) throws QvtoTransformationException {
        this.status = new MultiStatus(this.getPluginID(), 0, "Executed transformation: " + String.valueOf(this.getTransformationURI()), null);
        this.registerImportedUnits();
        ExecutionDiagnostic diagnostic = this.getExecutor().execute(this.createExecutionContext(new StatusLogger(this.status), this.itsMonitor), aModelParameters);
        if (diagnostic.getCode() == 100) {
            StatusLogger.LogStatus fatalLog = this.findFatalLog((IStatus)this.status);
            if (fatalLog == null) {
                this.status.add(BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
            } else {
                fatalLog.setException((Throwable)((Object)new ExecutionDiagnosticException(diagnostic)));
            }
        } else {
            this.status.add(BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
        }
        if (this.status.getSeverity() >= 4) {
            throw new QvtoErrorStatusException((IStatus)this.status);
        }
    }

    private StatusLogger.LogStatus findFatalLog(IStatus status) {
        IStatus[] statuses = status.getChildren();
        int i = statuses.length - 1;
        while (i >= 0) {
            if (StatusLogger.LogStatus.LEVEL_FATAL == statuses[i].getCode()) {
                return (StatusLogger.LogStatus)statuses[i];
            }
            --i;
        }
        return null;
    }
}

