/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CodeActionCompletionProposal
implements ICompletionProposal {
    private CodeAction fcodeAction;
    private Command fcommand;
    private String fdisplayString;
    private final LanguageServiceAccessor.LSPDocumentInfo finfo;

    public CodeActionCompletionProposal(Either<Command, CodeAction> command, LanguageServiceAccessor.LSPDocumentInfo info) {
        this.finfo = info;
        if (command.isLeft()) {
            this.fcommand = (Command)command.getLeft();
            this.fdisplayString = this.fcommand.getTitle();
        } else if (command.isRight()) {
            this.fcodeAction = (CodeAction)command.getRight();
            this.fdisplayString = this.fcodeAction.getTitle();
        }
    }

    public void apply(IDocument document) {
        if (this.fcodeAction != null) {
            if (this.fcodeAction.getEdit() != null) {
                LSPEclipseUtils.applyWorkspaceEdit(this.fcodeAction.getEdit());
            }
            if (this.fcodeAction.getCommand() != null) {
                this.executeCommand(this.fcodeAction.getCommand());
            }
        } else if (this.fcommand != null) {
            this.executeCommand(this.fcommand);
        }
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return "";
    }

    public String getDisplayString() {
        return this.fdisplayString;
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return new ContextInformation("some context display string", "some information display string");
    }

    private void executeCommand(Command command) {
        ExecuteCommandOptions provider;
        ServerCapabilities capabilities = this.finfo.getCapabilites();
        if (capabilities != null && (provider = capabilities.getExecuteCommandProvider()) != null && provider.getCommands().contains(command.getCommand())) {
            ExecuteCommandParams params = new ExecuteCommandParams();
            params.setCommand(command.getCommand());
            params.setArguments(command.getArguments());
            this.finfo.getInitializedLanguageClient().thenAcceptAsync(ls -> {
                CompletableFuture completableFuture = ls.getWorkspaceService().executeCommand(params);
            });
        }
    }
}

