/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.LSDisplayHelper;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DocumentWillSaveWaitUntilTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
    }

    private List<TextEdit> createSingleTextEditAtFileStart(String newText) {
        TextEdit textEdit = new TextEdit();
        textEdit.setRange(new Range(new Position(0, 0), new Position(0, newText.length())));
        textEdit.setNewText(newText);
        return Collections.singletonList(textEdit);
    }

    @Test
    public void testSave() throws Exception {
        String oldText = "Hello";
        String newText = "hello";
        MockLanguageServer.INSTANCE.setWillSaveWaitUntil(this.createSingleTextEditAtFileStart(newText));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)LSPEclipseUtils.getDocument((IResource)testFile), capabilites -> Boolean.TRUE);
        viewer.getDocument().replace(0, 0, oldText);
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"Text has not been lowercased", (boolean)new LSDisplayHelper(() -> {
            try {
                return newText.equals(viewer.getDocument().get(0, newText.length()));
            }
            catch (BadLocationException e) {
                return false;
            }
        }).waitForCondition(Display.getCurrent(), 2000L));
    }
}

