/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.jdt;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.hover.LSPTextHover;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class LSJavaHoverProvider
extends JavadocHover {
    private static String fgStyleSheet;
    private static final String BODY_OPEN = "<body";
    private static final String BODY_CLOSE = "</body>";
    private static final String SEPARATOR = "<hr/>";
    private final LSPTextHover lsBasedHover = new LSPTextHover();

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        String jdtHtmlHoverContent;
        int leadingImageWidth;
        JavadocBrowserInformationControlInput previous;
        IJavaElement javaElement;
        AtomicReference jdtHoverControlInput;
        AtomicReference lsHtmlHoverContent;
        block7: {
            if (textViewer == null || hoverRegion == null) {
                return super.getHoverInfo2(textViewer, hoverRegion);
            }
            CompletableFuture lsHoverFuture = this.lsBasedHover.getHoverInfoFuture(textViewer, hoverRegion);
            lsHtmlHoverContent = new AtomicReference();
            jdtHoverControlInput = new AtomicReference();
            javaElement = null;
            previous = null;
            leadingImageWidth = 0;
            jdtHtmlHoverContent = "";
            CompletableFuture[] completableFutureArray = new CompletableFuture[2];
            completableFutureArray[0] = CompletableFuture.runAsync(() -> jdtHoverControlInput.set((JavadocBrowserInformationControlInput)super.getHoverInfo2(textViewer, hoverRegion)));
            completableFutureArray[1] = lsHoverFuture.thenAccept(lsHtmlHoverContent::set);
            CompletableFuture.allOf(completableFutureArray).get(1000L, TimeUnit.MILLISECONDS);
            if (lsHtmlHoverContent.get() != null) break block7;
            return null;
        }
        try {
            JavadocBrowserInformationControlInput input = (JavadocBrowserInformationControlInput)jdtHoverControlInput.get();
            if (input != null) {
                previous = (JavadocBrowserInformationControlInput)input.getPrevious();
                javaElement = input.getElement();
                leadingImageWidth = input.getLeadingImageWidth();
                jdtHtmlHoverContent = input.getHtml();
            }
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logWarning((String)"Javadoc unavailable. Failed to obtain it.", (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logWarning((String)"Javadoc unavailable. Failed to obtain it.", (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning((String)"Timeout waiting for data to generate LS hover", (Throwable)e);
            return null;
        }
        String content = this.formatContent((String)lsHtmlHoverContent.get(), jdtHtmlHoverContent);
        return new JavadocBrowserInformationControlInput(previous, javaElement, content, leadingImageWidth);
    }

    private String formatContent(String lsContent, String jdtContent) {
        if (lsContent != null && lsContent.trim().length() > 0 && jdtContent != null && jdtContent.trim().length() > 0) {
            return LSJavaHoverProvider.concatenateHtml(lsContent, jdtContent);
        }
        if (lsContent != null && (jdtContent == null || jdtContent.trim().isEmpty())) {
            return LSJavaHoverProvider.wrapHtml(lsContent).toString();
        }
        return String.valueOf(lsContent == null ? "" : lsContent) + (jdtContent == null ? "" : jdtContent);
    }

    private static StringBuilder wrapHtml(String html) {
        ColorRegistry registry = JFaceResources.getColorRegistry();
        RGB fgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.foregroundColor");
        RGB bgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.backgroundColor");
        StringBuilder buffer = new StringBuilder(html);
        HTMLPrinter.insertPageProlog((StringBuilder)buffer, (int)0, (RGB)fgRGB, (RGB)bgRGB, (String)LSJavaHoverProvider.getStyleSheet());
        HTMLPrinter.addPageEpilog((StringBuilder)buffer);
        return buffer;
    }

    private static String concatenateHtml(String lsHtml, String jdtHtml) {
        int insertPosition = jdtHtml.indexOf(BODY_OPEN);
        if (insertPosition >= 0) {
            if ((insertPosition = jdtHtml.indexOf(62, insertPosition)) >= 0 && insertPosition < jdtHtml.length()) {
                ++insertPosition;
                int bodyStartIdx = lsHtml.indexOf(BODY_OPEN);
                int bodyEndIdx = -1;
                if (bodyStartIdx >= 0) {
                    if ((bodyStartIdx = lsHtml.indexOf(62, bodyStartIdx)) >= 0 && bodyStartIdx < lsHtml.length()) {
                        if ((bodyEndIdx = lsHtml.indexOf(BODY_CLOSE, ++bodyStartIdx)) >= bodyStartIdx && bodyEndIdx <= lsHtml.length()) {
                            return String.valueOf(jdtHtml.substring(0, insertPosition)) + lsHtml.substring(bodyStartIdx, bodyEndIdx) + SEPARATOR + jdtHtml.substring(insertPosition);
                        }
                        LanguageServerPlugin.logWarning((String)"LS Hover Html and JDT hover html were naively concatenated as LS hover HTML BODY tag closing bracket is at invalid position", null);
                    } else {
                        LanguageServerPlugin.logWarning((String)"LS Hover Html and JDT hover html were naively concatenated as LS hover HTML BODY tag closing bracket wasn't found", null);
                    }
                } else {
                    LanguageServerPlugin.logWarning((String)"LS Hover Html and JDT hover html were naively concatenated as LS hover HTML BODY tag wasn't found", null);
                }
            } else {
                LanguageServerPlugin.logWarning((String)"LS Hover Html and JDT hover html were naively concatenated as JDT hover HTML BODY tag closing bracket wasn't found", null);
            }
        } else {
            LanguageServerPlugin.logWarning((String)"LS Hover Html and JDT hover html were naively concatenated as JDT hover HTML BODY tag wasn't found", null);
        }
        return String.valueOf(lsHtml) + SEPARATOR + jdtHtml;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return this.lsBasedHover.getHoverRegion(textViewer, offset);
    }

    private static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = JavadocHover.loadStyleSheet((String)"/JavadocHoverStyleSheet.css");
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }
}

