/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.outline.LSSymbolsContentProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolLocation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class SymbolsLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IEclipsePreferences.IPreferenceChangeListener {
    private final Map<IResource, RangeMap<Integer, Integer>> severities = new HashMap<IResource, RangeMap<Integer, Integer>>();
    private final IResourceChangeListener listener = e -> {
        try {
            IResourceDelta delta = e.getDelta();
            if (delta != null) {
                delta.accept(d -> {
                    if (d.getMarkerDeltas().length > 0) {
                        this.severities.remove(d.getResource());
                    }
                    return true;
                });
            }
        }
        catch (CoreException ex) {
            LanguageServerPlugin.logError(ex);
        }
    };
    private final Map<Image, Image[]> overlays = new HashMap<Image, Image[]>();
    private final boolean showLocation;
    private boolean showKind;

    public SymbolsLabelProvider() {
        this(false, InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").getBoolean("org.eclipse.lsp4e.outline.showKind", false));
    }

    public SymbolsLabelProvider(boolean showLocation, boolean showKind) {
        this.showLocation = showLocation;
        this.showKind = showKind;
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.overlays.values().stream().flatMap(Arrays::stream).filter(Objects::nonNull).forEach(Resource::dispose);
        this.overlays.clear();
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element == LSSymbolsContentProvider.COMPUTING) {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }
        if (element instanceof Throwable) {
            return LSPImages.getSharedImage("IMG_OBJS_ERROR_TSK");
        }
        if (element instanceof Either var2_3) {
            element = either.get();
        }
        Image res = null;
        if (element instanceof SymbolInformation var6_6) {
            res = LSPImages.imageFromSymbolKind(info.getKind());
        } else {
            if (element instanceof WorkspaceSymbol var9_8) {
                res = LSPImages.imageFromSymbolKind(symbol.getKind());
            } else {
                if (element instanceof DocumentSymbol var12_10) {
                    res = LSPImages.imageFromSymbolKind(symbol.getKind());
                } else {
                    if (element instanceof SymbolsModel.DocumentSymbolWithFile var15_12) {
                        res = LSPImages.imageFromSymbolKind(symbolWithFile.symbol.getKind());
                    }
                }
            }
        }
        IResource file = null;
        if (element instanceof SymbolInformation var19_15) {
            file = LSPEclipseUtils.findResourceFor(symbol.getLocation().getUri());
        } else {
            if (element instanceof WorkspaceSymbol var22_17) {
                file = LSPEclipseUtils.findResourceFor(SymbolsLabelProvider.getUri((WorkspaceSymbol)symbol));
            } else {
                if (element instanceof SymbolsModel.DocumentSymbolWithFile var25_19) {
                    file = symbolWithFile.file;
                }
            }
        }
        if (file != null) {
            Range range = null;
            if (element instanceof SymbolInformation var29_22) {
                range = symbol.getLocation().getRange();
            } else {
                if (element instanceof WorkspaceSymbol var32_24 && symbol.getLocation().isLeft()) {
                    range = ((Location)symbol.getLocation().getLeft()).getRange();
                } else {
                    if (element instanceof DocumentSymbol var35_26) {
                        range = documentSymbol.getRange();
                    } else {
                        if (element instanceof SymbolsModel.DocumentSymbolWithFile var38_28) {
                            range = symbolWithFile.symbol.getRange();
                        }
                    }
                }
            }
            if (range != null) {
                try {
                    IDocument doc = LSPEclipseUtils.getExistingDocument(file);
                    if (doc != null && (maxSeverity = this.getMaxSeverity(file, doc, range)) > 0) {
                        return this.getOverlay(res, maxSeverity);
                    }
                }
                catch (CoreException | BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        return res;
    }

    protected int getMaxSeverity(@NonNull IResource resource, @NonNull IDocument doc, @NonNull Range range) throws CoreException, BadLocationException {
        RangeMap<Integer, Integer> severitiesForResource;
        if (!this.severities.containsKey(resource)) {
            this.refreshMarkersByLine(resource);
        }
        if ((severitiesForResource = this.severities.get(resource)) == null) {
            return -1;
        }
        int bound1 = LSPEclipseUtils.toOffset(range.getStart(), doc);
        int bound2 = LSPEclipseUtils.toOffset(range.getEnd(), doc);
        com.google.common.collect.Range subRange = com.google.common.collect.Range.closed((Comparable)Integer.valueOf(Math.min(bound1, bound2)), (Comparable)Integer.valueOf(bound2));
        return severitiesForResource.subRangeMap(subRange).asMapOfRanges().values().stream().max(Comparator.naturalOrder()).orElse(-1);
    }

    private void refreshMarkersByLine(IResource resource) throws CoreException {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        Arrays.stream(resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0)).filter(marker -> marker.getAttribute("severity", -1) > 0).sorted(Comparator.comparingInt(marker -> marker.getAttribute("severity", -1))).forEach(arg_0 -> SymbolsLabelProvider.lambda$7((RangeMap)rangeMap, arg_0));
        this.severities.put(resource, (RangeMap<Integer, Integer>)rangeMap);
    }

    private Image getOverlay(Image res, int maxSeverity) {
        if (maxSeverity != 1 && maxSeverity != 2) {
            throw new IllegalArgumentException("Severity " + maxSeverity + " not supported.");
        }
        Image[] currentOverlays = this.overlays.computeIfAbsent(res, key -> new Image[2]);
        if (currentOverlays[maxSeverity - 1] == null) {
            String overlayId = null;
            if (maxSeverity == 2) {
                overlayId = "IMG_DEC_FIELD_ERROR";
            } else if (maxSeverity == 1) {
                overlayId = "IMG_DEC_FIELD_WARNING";
            }
            currentOverlays[maxSeverity - 1] = new DecorationOverlayIcon(res, LSPImages.getSharedImageDescriptor(overlayId), 2).createImage();
        }
        return currentOverlays[maxSeverity - 1];
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        if (element == LSSymbolsContentProvider.COMPUTING) {
            return new StyledString(Messages.outline_computingSymbols);
        }
        if (element instanceof Throwable var2_3) {
            String message = throwable.getMessage();
            if (message == null) {
                message = element.getClass().getName();
            }
            return new StyledString(message);
        }
        StyledString res = new StyledString();
        if (element == null) {
            return res;
        }
        if (element instanceof Either var6_7) {
            element = either.get();
        }
        String name = null;
        SymbolKind kind = null;
        String detail = null;
        URI location = null;
        if (element instanceof SymbolInformation var13_13) {
            name = symbolInformation.getName();
            kind = symbolInformation.getKind();
            try {
                location = URI.create(symbolInformation.getLocation().getUri());
            }
            catch (IllegalArgumentException e) {
                LanguageServerPlugin.logError("Invalid URI: " + symbolInformation.getLocation().getUri(), e);
            }
        } else {
            if (element instanceof WorkspaceSymbol e) {
                name = workspaceSymbol.getName();
                kind = workspaceSymbol.getKind();
                String rawUri = SymbolsLabelProvider.getUri((WorkspaceSymbol)workspaceSymbol);
                try {
                    location = URI.create(rawUri);
                }
                catch (IllegalArgumentException e) {
                    LanguageServerPlugin.logError("Invalid URI: " + rawUri, e);
                }
            } else {
                if (element instanceof DocumentSymbol rawUri) {
                    name = documentSymbol.getName();
                    kind = documentSymbol.getKind();
                    detail = documentSymbol.getDetail();
                } else {
                    if (element instanceof SymbolsModel.DocumentSymbolWithFile var22_22) {
                        name = symbolWithFile.symbol.getName();
                        kind = symbolWithFile.symbol.getKind();
                        detail = symbolWithFile.symbol.getDetail();
                        IFile file = symbolWithFile.file;
                        if (file != null) {
                            location = file.getLocationURI();
                        }
                    }
                }
            }
        }
        if (name != null) {
            res.append(name, null);
        }
        if (detail != null) {
            res.append(detail, StyledString.DECORATIONS_STYLER);
        }
        if (this.showKind && kind != null) {
            res.append(" :", null);
            res.append(kind.toString(), StyledString.DECORATIONS_STYLER);
        }
        if (this.showLocation && location != null) {
            res.append(' ');
            res.append(location.getPath(), StyledString.QUALIFIER_STYLER);
        }
        return res;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.eclipse.lsp4e.outline.showKind")) {
            this.showKind = Boolean.valueOf(event.getNewValue().toString());
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                if (listener instanceof ILabelProviderListener var6_6) {
                    labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
                }
                ++n2;
            }
        }
    }

    private static String getUri(WorkspaceSymbol symbol) {
        return (String)symbol.getLocation().map(Location::getUri, WorkspaceSymbolLocation::getUri);
    }

    private static /* synthetic */ void lambda$7(RangeMap rangeMap, IMarker marker) {
        int start = marker.getAttribute("charStart", -1);
        int end = marker.getAttribute("charEnd", -1);
        if (end < start) {
            end = start;
        }
        int severity = marker.getAttribute("severity", -1);
        if (start != end) {
            com.google.common.collect.Range markerRange = com.google.common.collect.Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end - 1));
            rangeMap.remove(markerRange);
            rangeMap.put(markerRange, (Object)severity);
        }
    }
}

