/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.hover;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.util.Util;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class FocusableBrowserInformationControl
extends BrowserInformationControl {
    private static final String HEAD = "<head>";
    private static final String HTML_TEMPLATE = "<head>%s</head>%s";
    private static final LocationListener HYPER_LINK_LISTENER = new LocationListener(){

        public void changing(LocationEvent event) {
            if (!"about:blank".equals(event.location)) {
                LSPEclipseUtils.open(event.location, null);
                event.doit = false;
            }
        }

        public void changed(LocationEvent event) {
        }
    };

    public FocusableBrowserInformationControl(Shell parent, String symbolicFontName, boolean resizable) {
        super(parent, "org.eclipse.jface.defaultfont", resizable);
    }

    public FocusableBrowserInformationControl(Shell parent) {
        super(parent, "org.eclipse.jface.defaultfont", EditorsUI.getTooltipAffordanceString());
    }

    /*
     * WARNING - void declaration
     */
    private double adjust(double height, Object margin) {
        Object object = margin;
        if (object instanceof String) {
            void marginString;
            String string = (String)object;
            String cfr_ignored_0 = (String)object;
            if (marginString.endsWith("px")) {
                try {
                    height += (double)Integer.parseInt(marginString.substring(0, marginString.length() - 2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return height;
    }

    protected void createContent(Composite parent) {
        super.createContent(parent);
        Browser b = (Browser)parent.getChildren()[0];
        b.addProgressListener(ProgressListener.completedAdapter(event -> {
            if (this.getInput() == null) {
                return;
            }
            Browser browser = (Browser)event.getSource();
            @Nullable Point constraints = this.getSizeConstraints();
            Point hint = this.computeSizeHint();
            this.setSize(hint.x, hint.y);
            browser.execute("document.getElementsByTagName(\"html\")[0].style.whiteSpace = \"nowrap\"");
            Double width = 20.0 + (Double)browser.evaluate("return document.body.scrollWidth;");
            this.setSize(width.intValue(), hint.y);
            browser.execute("document.getElementsByTagName(\"html\")[0].style.whiteSpace = \"normal\"");
            Double height = (Double)browser.evaluate("return document.body.scrollHeight;");
            Object marginTop = browser.evaluate("return window.getComputedStyle(document.body).marginTop;");
            Object marginBottom = browser.evaluate("return getComputedStyle(document.body).marginBottom;");
            if (Platform.getPreferencesService().getBoolean("org.eclipse.ui.editors", "showTextHoverAffordance", true, null)) {
                FontData[] fontDatas = JFaceResources.getDialogFont().getFontData();
                height = (double)fontDatas[0].getHeight() + height;
            }
            width = width * 1.5;
            if (Util.isWin32()) {
                height = this.adjust(height, marginTop);
                height = this.adjust(height, marginBottom);
            }
            if (constraints != null && (double)constraints.x < width) {
                width = constraints.x;
            }
            if (constraints != null && (double)constraints.y < height) {
                height = constraints.y;
            }
            this.setSize(width.intValue(), height.intValue());
        }));
        b.setJavascriptEnabled(true);
    }

    /*
     * WARNING - void declaration
     */
    public void setInput(Object input) {
        Object object = input;
        if (object instanceof String) {
            void html;
            String string = (String)object;
            String cfr_ignored_0 = (String)object;
            input = this.styleHtml((String)html);
        }
        super.setInput(input);
    }

    public String styleHtml(String html) {
        if (html == null || html.isEmpty()) {
            return html;
        }
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        Color foreground = colorRegistry.get("org.eclipse.ui.workbench.HOVER_FOREGROUND");
        Color background = colorRegistry.get("org.eclipse.ui.workbench.HOVER_BACKGROUND");
        String style = "<style TYPE='text/css'>html { font-family: " + JFaceResources.getDefaultFontDescriptor().getFontData()[0].getName() + "; " + "font-size: " + Integer.toString(JFaceResources.getDefaultFontDescriptor().getFontData()[0].getHeight()) + "pt; " + (background != null ? "background-color: " + FocusableBrowserInformationControl.toHTMLrgb(background.getRGB()) + "; " : "") + (foreground != null ? "color: " + FocusableBrowserInformationControl.toHTMLrgb(foreground.getRGB()) + "; " : "") + " }</style>";
        String hlStyle = null;
        try {
            URL urlHJScript = FileLocator.toFileURL((URL)((Object)((Object)LanguageServerPlugin.getDefault())).getClass().getResource("/resources/highlight.min.js/highlight.min.js"));
            URL urlHJCss = FileLocator.toFileURL((URL)((Object)((Object)LanguageServerPlugin.getDefault())).getClass().getResource(this.isDarkTheme() ? "/resources/highlight.min.js/styles/dark.min.css" : "/resources/highlight.min.js/styles/default.min.css"));
            if (urlHJScript != null && urlHJCss != null) {
                hlStyle = "<link rel='stylesheet' href='" + urlHJCss + "'>" + "<script src='" + urlHJScript + "'></script>" + "<script>hljs.highlightAll();</script>";
            }
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
        int headIndex = html.indexOf(HEAD);
        String headContent = String.valueOf(style) + Strings.nullToEmpty(hlStyle);
        if (headIndex > 0) {
            return new StringBuilder(html).insert(headIndex, headContent).toString();
        }
        return String.format(HTML_TEMPLATE, headContent, html);
    }

    private boolean isDarkTheme() {
        RGB color = this.getShell().getBackground().getRGB();
        return (double)color.red * 0.299 + (double)color.green * 0.587 + (double)color.blue * 0.114 < 128.0;
    }

    private static @NonNull CharSequence toHTMLrgb(RGB rgb) {
        StringBuilder builder = new StringBuilder(7);
        builder.append('#');
        FocusableBrowserInformationControl.appendAsHexString(builder, rgb.red);
        FocusableBrowserInformationControl.appendAsHexString(builder, rgb.green);
        FocusableBrowserInformationControl.appendAsHexString(builder, rgb.blue);
        return builder;
    }

    private static void appendAsHexString(StringBuilder buffer, int intValue) {
        String hexValue = Integer.toHexString(intValue);
        if (hexValue.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hexValue);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return parent -> {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                FocusableBrowserInformationControl res = new FocusableBrowserInformationControl(parent, "org.eclipse.jface.defaultfont", true);
                res.addLocationListener(HYPER_LINK_LISTENER);
                return res;
            }
            return new DefaultInformationControl(parent);
        };
    }
}

