/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.operations.semanticTokens.SemanticTokensDataStreamProcessor;
import org.eclipse.lsp4e.test.semanticTokens.SemanticTokensTestUtil;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.swt.custom.StyleRange;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SemanticTokensDataStreamProcessorTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Test
    public void testKeyword() throws InterruptedException, ExecutionException {
        Document document = new Document("type foo {\n\t\n}\ntype bar extends foo {\n\t\n}\n");
        SemanticTokensDataStreamProcessor processor = new SemanticTokensDataStreamProcessor(SemanticTokensTestUtil.keywordTokenTypeMapper(SemanticTokensTestUtil.RED_TOKEN), SemanticTokensTestUtil.offsetMapper((IDocument)document));
        List<Integer> expectedStream = SemanticTokensTestUtil.keywordSemanticTokens();
        List<StyleRange> expectedStyleRanges = Arrays.asList(new StyleRange(0, 4, SemanticTokensTestUtil.RED, null), new StyleRange(15, 4, SemanticTokensTestUtil.RED, null), new StyleRange(24, 7, SemanticTokensTestUtil.RED, null));
        List styleRanges = processor.getStyleRanges(expectedStream, this.getSemanticTokensLegend());
        Assert.assertEquals(expectedStyleRanges, (Object)styleRanges);
    }

    private SemanticTokensLegend getSemanticTokensLegend() {
        SemanticTokensLegend semanticTokensLegend = new SemanticTokensLegend();
        semanticTokensLegend.setTokenTypes(Arrays.asList("keyword", "other"));
        semanticTokensLegend.setTokenModifiers(Arrays.asList("obsolete"));
        return semanticTokensLegend;
    }
}

