/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.utils;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.lsp4e.test.utils.MockConnectionProvider;

public class MockConnectionProviderWithStartException
extends MockConnectionProvider {
    private static volatile CompletableFuture<Void> startFuture = new CompletableFuture();
    private static volatile int startCounter = 0;
    private static volatile int stopCounter = 0;

    public static void resetStartFuture() {
        startFuture = new CompletableFuture();
    }

    public static void waitForStart() throws ExecutionException, InterruptedException, TimeoutException {
        startFuture.get(2L, TimeUnit.SECONDS);
    }

    public static void resetCounters() {
        startCounter = 0;
        stopCounter = 0;
    }

    public static int getStartCounter() {
        return startCounter;
    }

    public static int getStopCounter() {
        return stopCounter;
    }

    @Override
    public void start() throws IOException {
        ++startCounter;
        startFuture.complete(null);
        throw new IOException("Start failed");
    }

    @Override
    public void stop() {
        ++stopCounter;
    }
}

