/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.typeHierarchy;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.views.HierarchyViewInput;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.TypeHierarchyPrepareParams;
import org.eclipse.lsp4j.TypeHierarchySubtypesParams;
import org.eclipse.lsp4j.TypeHierarchySupertypesParams;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.ui.PlatformUI;

public class TypeHierarchyViewContentProvider
implements ITreeContentProvider {
    private TreeViewer treeViewer;
    private LanguageServerWrapper languageServerWrapper;
    private List<TypeHierarchyItem> hierarchyItems = Collections.emptyList();
    public boolean showSuperTypes = true;
    public IDocument document;

    public Object[] getElements(Object inputElement) {
        if (this.hierarchyItems.isEmpty()) {
            return new Object[]{Messages.TH_no_type_hierarchy};
        }
        return this.hierarchyItems.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TypeHierarchyItem) {
            TypeHierarchyItem parentItem = (TypeHierarchyItem)parentElement;
            try {
                return (Object[])((CompletableFuture)this.languageServerWrapper.execute(ls -> {
                    TextDocumentService textDocumentService = ls.getTextDocumentService();
                    return this.showSuperTypes ? textDocumentService.typeHierarchySupertypes(new TypeHierarchySupertypesParams(parentItem)) : textDocumentService.typeHierarchySubtypes(new TypeHierarchySubtypesParams(parentItem));
                }).thenApply(list -> list == null ? new Object[]{} : list.toArray(Object[]::new))).get(500L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof HierarchyViewInput) {
            IDocument document;
            HierarchyViewInput viewInput = (HierarchyViewInput)newInput;
            this.document = document = viewInput.getDocument();
            if (document != null) {
                try {
                    this.initialise(document, viewInput.getOffset(), (TreeViewer)viewer);
                }
                catch (BadLocationException e) {
                    this.handleRootError();
                }
            } else {
                this.handleRootError();
            }
        } else {
            this.handleRootError();
        }
    }

    private void initialise(@NonNull IDocument document, int offset, TreeViewer viewer) throws BadLocationException {
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getTypeHierarchyProvider);
        if (!executor.anyMatching()) {
            this.handleRootError();
            return;
        }
        TypeHierarchyPrepareParams prepareParams = TypeHierarchyViewContentProvider.toTypeHierarchyPrepareParams(offset, document);
        ((CompletableFuture)executor.computeFirst((w, ls) -> ls.getTextDocumentService().prepareTypeHierarchy(prepareParams).thenApply(result -> new Pair<LanguageServerWrapper, List>((LanguageServerWrapper)w, (List)result))).thenAccept(o -> o.ifPresentOrElse(p -> {
            this.languageServerWrapper = (LanguageServerWrapper)p.getFirst();
            if (!((List)p.getSecond()).isEmpty()) {
                this.hierarchyItems = (List)p.getSecond();
                this.treeViewer = viewer;
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    if (this.treeViewer != null) {
                        this.treeViewer.refresh();
                        this.treeViewer.expandToLevel(2);
                        if (!this.hierarchyItems.isEmpty()) {
                            this.treeViewer.getControl().setEnabled(true);
                            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.hierarchyItems.get(0)));
                        }
                    }
                });
            }
        }, this::handleRootError))).handle((result, error) -> {
            if (error != null) {
                this.handleRootError();
            }
            return result;
        });
    }

    private static TypeHierarchyPrepareParams toTypeHierarchyPrepareParams(int offset, @NonNull IDocument document) throws BadLocationException {
        Position position = LSPEclipseUtils.toPosition(offset, document);
        TextDocumentIdentifier documentIdentifier = LSPEclipseUtils.toTextDocumentIdentifier(document);
        return new TypeHierarchyPrepareParams(documentIdentifier, position);
    }

    private void handleRootError() {
        this.hierarchyItems = Collections.emptyList();
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.treeViewer != null) {
                this.treeViewer.refresh();
            }
        });
    }

    public void dispose() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().dispose();
            this.treeViewer = null;
        }
    }
}

