/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CommandMarkerResolution
extends WorkbenchMarkerResolution
implements IMarkerResolution {
    private final @NonNull Command command;

    public CommandMarkerResolution(@NonNull Command command) {
        this.command = command;
    }

    public String getLabel() {
        return this.command.getTitle();
    }

    public void run(IMarker marker) {
        LanguageServersRegistry.LanguageServerDefinition definition;
        IResource resource = marker.getResource();
        if (resource == null) {
            return;
        }
        String languageServerId = marker.getAttribute("languageServerId", null);
        LanguageServersRegistry.LanguageServerDefinition languageServerDefinition = definition = languageServerId != null ? LanguageServersRegistry.getInstance().getDefinition(languageServerId) : null;
        if (definition == null) {
            return;
        }
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper(resource.getProject(), definition);
        if (wrapper != null) {
            ExecuteCommandOptions provider = wrapper.getServerCapabilities().getExecuteCommandProvider();
            if (provider != null && provider.getCommands().contains(this.command.getCommand())) {
                wrapper.execute(ls -> ls.getWorkspaceService().executeCommand(new ExecuteCommandParams(this.command.getCommand(), this.command.getArguments())));
            } else {
                CommandExecutor.executeCommandClientSide(this.command, resource);
            }
        }
    }

    public String getDescription() {
        return this.command.getTitle();
    }

    public Image getImage() {
        return null;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return new IMarker[0];
    }
}

