/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.commands;

import com.google.gson.Gson;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DynamicRegistrationTest
extends AbstractTestWithProject {
    private static final String WORKSPACE_EXECUTE_COMMAND = "workspace/executeCommand";
    private static final String WORKSPACE_DID_CHANGE_FOLDERS = "workspace/didChangeWorkspaceFolders";

    @Before
    public void setUp() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseExtension.lspt", "");
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assert.assertNotNull((Object)document);
        LanguageServers.forDocument((IDocument)document).anyMatching();
        TestUtils.waitForCondition(5000, () -> !MockLanguageServer.INSTANCE.getRemoteProxies().isEmpty());
        this.getMockClient();
    }

    @Test
    public void testCommandRegistration() throws Exception {
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> true));
        Assert.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command")));
        UUID registration = this.registerCommands("test.command", "test.command.2");
        try {
            Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command")));
            Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command.2")));
        }
        finally {
            this.unregister(registration);
        }
        Assert.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command")));
        Assert.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command.2")));
    }

    @Test
    public void testWorkspaceFoldersRegistration() throws Exception {
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> true));
        Assert.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> this.hasWorkspaceFolderSupport((ServerCapabilities)c)));
        UUID registration = this.registerWorkspaceFolders();
        try {
            Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> this.hasWorkspaceFolderSupport((ServerCapabilities)c)));
        }
        finally {
            this.unregister(registration);
        }
        Assert.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> this.hasWorkspaceFolderSupport((ServerCapabilities)c)));
        Assert.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> !this.hasWorkspaceFolderSupport((ServerCapabilities)c)));
    }

    private void unregister(UUID registration) throws Exception {
        LanguageClient client = this.getMockClient();
        Unregistration unregistration = new Unregistration(registration.toString(), WORKSPACE_EXECUTE_COMMAND);
        client.unregisterCapability(new UnregistrationParams(List.of(unregistration))).get(1L, TimeUnit.SECONDS);
    }

    private UUID registerWorkspaceFolders() throws Exception {
        UUID id = UUID.randomUUID();
        LanguageClient client = this.getMockClient();
        Registration registration = new Registration();
        registration.setId(id.toString());
        registration.setMethod(WORKSPACE_DID_CHANGE_FOLDERS);
        client.registerCapability(new RegistrationParams(List.of(registration))).get(1L, TimeUnit.SECONDS);
        return id;
    }

    private UUID registerCommands(String ... command) throws Exception {
        UUID id = UUID.randomUUID();
        LanguageClient client = this.getMockClient();
        Registration registration = new Registration();
        registration.setId(id.toString());
        registration.setMethod(WORKSPACE_EXECUTE_COMMAND);
        registration.setRegisterOptions((Object)new Gson().toJsonTree((Object)new ExecuteCommandOptions(List.of(command))));
        client.registerCapability(new RegistrationParams(List.of(registration))).get(1L, TimeUnit.SECONDS);
        return id;
    }

    private LanguageClient getMockClient() {
        List proxies = MockLanguageServer.INSTANCE.getRemoteProxies();
        Assert.assertEquals((long)1L, (long)proxies.size());
        return (LanguageClient)proxies.get(0);
    }

    private Predicate<ServerCapabilities> handlesCommand(String command) {
        return cap -> {
            ExecuteCommandOptions commandProvider = cap.getExecuteCommandProvider();
            return commandProvider != null && commandProvider.getCommands().contains(command);
        };
    }

    private boolean hasWorkspaceFolderSupport(ServerCapabilities cap) {
        WorkspaceFoldersOptions f;
        WorkspaceServerCapabilities ws;
        if (cap != null && (ws = cap.getWorkspace()) != null && (f = ws.getWorkspaceFolders()) != null) {
            return f.getSupported();
        }
        return false;
    }
}

