/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.websocket.jakarta;

import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.messages.Message;

public class WebSocketMessageConsumer
implements MessageConsumer {
    private static final Logger LOG = Logger.getLogger(WebSocketMessageConsumer.class.getName());
    private final Session session;
    private final MessageJsonHandler jsonHandler;
    private final ConcurrentLinkedQueue<String> messageQueue = new ConcurrentLinkedQueue();
    private final WebSocketSendHandler handler = new WebSocketSendHandler();

    public WebSocketMessageConsumer(Session session, MessageJsonHandler jsonHandler) {
        this.session = session;
        this.jsonHandler = jsonHandler;
    }

    public Session getSession() {
        return this.session;
    }

    public void consume(Message message) {
        String content = this.jsonHandler.serialize(message);
        try {
            this.sendMessage(content);
        }
        catch (IOException exception) {
            throw new JsonRpcException((Throwable)exception);
        }
    }

    protected void sendMessage(String message) throws IOException {
        if (this.session.isOpen()) {
            int length = message.length();
            if (length <= this.session.getMaxTextMessageBufferSize()) {
                this.messageQueue.add(message);
                this.handler.handleNextMessage();
            } else {
                int currentOffset = 0;
                while (currentOffset < length) {
                    int currentEnd = Math.min(currentOffset + this.session.getMaxTextMessageBufferSize(), length);
                    this.session.getBasicRemote().sendText(message.substring(currentOffset, currentEnd), currentEnd == length);
                    currentOffset = currentEnd;
                }
            }
        } else {
            LOG.log(Level.INFO, "Ignoring message due to closed session: {0}", message);
        }
    }

    private class WebSocketSendHandler
    implements SendHandler {
        private final AtomicBoolean isSending = new AtomicBoolean();

        private WebSocketSendHandler() {
        }

        public void onResult(SendResult result) {
            this.isSending.set(false);
            this.handleNextMessage();
        }

        void handleNextMessage() {
            if (WebSocketMessageConsumer.this.session.isOpen() && !WebSocketMessageConsumer.this.messageQueue.isEmpty() && this.isSending.compareAndSet(false, true)) {
                WebSocketMessageConsumer.this.session.getAsyncRemote().sendText(WebSocketMessageConsumer.this.messageQueue.poll(), (SendHandler)this);
            }
        }
    }
}

