/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.diagnostics;

import java.util.Collections;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.commons.DocumentFormat;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsSettings;
import org.eclipse.lsp4jakarta.jdt.core.java.AbstractJavaContext;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;

public class JavaDiagnosticsContext
extends AbstractJavaContext {
    private final DocumentFormat documentFormat;
    private final JakartaJavaDiagnosticsSettings settings;

    public JavaDiagnosticsContext(String uri, ITypeRoot typeRoot, IJDTUtils utils, DocumentFormat documentFormat, JakartaJavaDiagnosticsSettings settings) {
        super(uri, typeRoot, utils);
        this.documentFormat = documentFormat;
        this.settings = settings == null ? new JakartaJavaDiagnosticsSettings(Collections.emptyList()) : settings;
    }

    public DocumentFormat getDocumentFormat() {
        return this.documentFormat;
    }

    public JakartaJavaDiagnosticsSettings getSettings() {
        return this.settings;
    }

    public Diagnostic createDiagnostic(String uri, String message, Range range, String source, IJavaErrorCode code) {
        return this.createDiagnostic(uri, message, range, source, code, DiagnosticSeverity.Warning);
    }

    public Diagnostic createDiagnostic(String uri, String message, Range range, String source, IJavaErrorCode code, DiagnosticSeverity severity) {
        return this.createDiagnostic(uri, message, range, source, null, code, severity);
    }

    public Diagnostic createDiagnostic(String uri, String message, Range range, String source, Object data, IJavaErrorCode code, DiagnosticSeverity severity) {
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setSource(source);
        diagnostic.setMessage(message);
        diagnostic.setSeverity(severity);
        diagnostic.setRange(range);
        if (code != null) {
            diagnostic.setCode(code.getCode());
        }
        if (data != null) {
            diagnostic.setData(data);
        }
        return diagnostic;
    }
}

