/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.core.ls;

import java.io.Reader;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.commons.DocumentFormat;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;

public class JDTUtilsLSImpl
implements IJDTUtils {
    private static final int COMPILATION_UNIT_UPDATE_TIMEOUT = 3000;
    private static final IJDTUtils INSTANCE = new JDTUtilsLSImpl();

    public static IJDTUtils getInstance() {
        return INSTANCE;
    }

    private JDTUtilsLSImpl() {
    }

    @Override
    public IFile findFile(String uriString) {
        return JDTUtils.findFile((String)uriString);
    }

    @Override
    public ICompilationUnit resolveCompilationUnit(String uriString) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)uriString);
        try {
            long endTime = System.currentTimeMillis() + 3000L;
            while (!unit.isConsistent() && System.currentTimeMillis() < endTime) {
            }
        }
        catch (JavaModelException javaModelException) {}
        return unit;
    }

    @Override
    public IClassFile resolveClassFile(String uriString) {
        return JDTUtils.resolveClassFile((String)uriString);
    }

    @Override
    public boolean isHiddenGeneratedElement(IJavaElement element) {
        return JDTUtils.isHiddenGeneratedElement((IJavaElement)element);
    }

    @Override
    public Range toRange(IOpenable openable, int offset, int length) throws JavaModelException {
        return JDTUtils.toRange((IOpenable)openable, (int)offset, (int)length);
    }

    @Override
    public String toClientUri(String uri) {
        return ResourceUtils.toClientUri((String)uri);
    }

    @Override
    public String toUri(ITypeRoot typeRoot) {
        return JDTUtils.toUri((ITypeRoot)typeRoot);
    }

    @Override
    public void waitForLifecycleJobs(IProgressMonitor monitor) {
        try {
            Job.getJobManager().join((Object)"DocumentLifeCycleJobs", monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException((String)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int toOffset(IBuffer buffer, int line, int column) {
        return JsonRpcHelpers.toOffset((IBuffer)buffer, (int)line, (int)column);
    }

    @Override
    public Location toLocation(IJavaElement element) throws JavaModelException {
        return JDTUtils.toLocation((IJavaElement)element);
    }

    @Override
    public String getJavadoc(IMember member, DocumentFormat documentFormat) throws JavaModelException {
        boolean markdown = DocumentFormat.Markdown.equals((Object)documentFormat);
        Reader reader = markdown ? JavadocContentAccess.getMarkdownContentReader((IMember)member) : JavadocContentAccess.getPlainTextContentReader((IMember)member);
        return reader != null ? JDTUtilsLSImpl.toString(reader) : null;
    }

    private static String toString(Reader reader) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner s = new Scanner(reader);){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

