/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.commons.metadata.ConfigurationMetadata;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.commons.metadata.ValueHint;
import org.eclipse.lsp4mp.commons.metadata.ValueProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;

public class PropertiesCollector
implements IPropertiesCollector {
    private final ConfigurationMetadata configuration;
    private final Map<String, ItemHint> hintsCache;
    private final boolean onlySources;

    public PropertiesCollector(ConfigurationMetadata configuration, List<MicroProfilePropertiesScope> scopes) {
        this.configuration = configuration;
        this.configuration.setProperties(new ArrayList<ItemMetadata>());
        this.configuration.setHints(new ArrayList<ItemHint>());
        this.hintsCache = new HashMap<String, ItemHint>();
        this.onlySources = MicroProfilePropertiesScope.isOnlySources(scopes);
    }

    @Override
    public ItemMetadata addItemMetadata(String name, String type, String description, String sourceType, String sourceField, String sourceMethod, String defaultValue, String extensionName, boolean binary, int phase) {
        ItemMetadata property = new ItemMetadata();
        property.setName(name);
        property.setType(type);
        property.setDescription(description);
        property.setSourceType(sourceType);
        property.setSourceField(sourceField);
        property.setSourceMethod(sourceMethod);
        property.setDefaultValue(defaultValue);
        property.setExtensionName(extensionName);
        if (!binary) {
            property.setSource(Boolean.TRUE);
        }
        property.setPhase(phase);
        property.setRequired(defaultValue == null);
        this.configuration.getProperties().add(property);
        return property;
    }

    @Override
    public boolean hasItemHint(String hint) {
        return this.hintsCache.containsKey(hint);
    }

    @Override
    public ItemHint getItemHint(String hint) {
        ItemHint itemHint = this.getExistingItemHint(hint);
        if (itemHint != null) {
            return itemHint;
        }
        itemHint = new ItemHint();
        itemHint.setName(hint);
        itemHint.setValues(new ArrayList<ValueHint>());
        this.addItemHint(itemHint);
        return itemHint;
    }

    @Override
    public void merge(ConfigurationMetadata metadata, IPropertiesCollector.MergingStrategy mergingStrategy) {
        List<ItemHint> hints;
        List<ItemMetadata> properties = metadata.getProperties();
        if (properties != null) {
            for (ItemMetadata property : properties) {
                this.merge(property, mergingStrategy);
            }
        }
        if ((hints = metadata.getHints()) != null) {
            for (ItemHint itemHint : hints) {
                this.merge(itemHint, mergingStrategy);
            }
        }
    }

    private void merge(ItemMetadata property, IPropertiesCollector.MergingStrategy mergingStrategy) {
        if (this.onlySources && (property.getSource() == null || !property.getSource().booleanValue())) {
            return;
        }
        switch (mergingStrategy) {
            case IGNORE_IF_EXISTS: {
                this.mergeWithIgnoreIfExists(property);
                break;
            }
            case REPLACE: {
                this.mergeWithReplace(property);
                break;
            }
            default: {
                this.addProperty(property);
            }
        }
    }

    private void mergeWithIgnoreIfExists(ItemMetadata property) {
        Optional<ItemMetadata> configProperty = this.getExistingProperty(property);
        if (configProperty.isPresent()) {
            return;
        }
        this.addProperty(property);
    }

    private Optional<ItemMetadata> getExistingProperty(ItemMetadata property) {
        List<ItemMetadata> configProperties = this.configuration.getProperties();
        return configProperties.stream().filter(cp -> cp.getName().equals(property.getName())).findFirst();
    }

    private void mergeWithReplace(ItemMetadata property) {
        Optional<ItemMetadata> configProperty = this.getExistingProperty(property);
        if (configProperty.isPresent()) {
            this.configuration.getProperties().remove(configProperty.get());
        }
        this.addProperty(property);
    }

    private void addProperty(ItemMetadata property) {
        this.configuration.getProperties().add(property);
    }

    private void merge(ItemHint itemHint, IPropertiesCollector.MergingStrategy mergingStrategy) {
        ItemHint existingItemHint = this.getItemHint(itemHint.getName());
        PropertiesCollector.merge(itemHint.getValues(), existingItemHint, mergingStrategy);
        if (itemHint.getProviders() != null) {
            if (existingItemHint.getProviders() == null) {
                existingItemHint.setProviders(new ArrayList<ValueProvider>());
            }
            existingItemHint.getProviders().addAll(itemHint.getProviders());
        }
    }

    private static void merge(List<ValueHint> from, ItemHint to, IPropertiesCollector.MergingStrategy mergingStrategy) {
        if (from == null || from.isEmpty()) {
            return;
        }
        if (to.getValues() == null) {
            to.setValues(new ArrayList<ValueHint>());
        }
        block4: for (ValueHint fromValue : from) {
            switch (mergingStrategy) {
                case IGNORE_IF_EXISTS: {
                    if (PropertiesCollector.getExistingValue(fromValue.getValue(), to.getValues()).isPresent()) continue block4;
                    to.getValues().add(fromValue);
                    break;
                }
                case REPLACE: {
                    Optional<ValueHint> existingValue = PropertiesCollector.getExistingValue(fromValue.getValue(), to.getValues());
                    if (existingValue.isPresent()) {
                        to.getValues().remove(existingValue.get());
                    }
                    to.getValues().add(fromValue);
                    break;
                }
                default: {
                    to.getValues().add(fromValue);
                }
            }
        }
    }

    private static Optional<ValueHint> getExistingValue(String name, List<ValueHint> values) {
        return values.stream().filter(cp -> cp.getValue().equals(name)).findFirst();
    }

    private ItemHint getExistingItemHint(String hint) {
        return this.hintsCache.get(hint);
    }

    private void addItemHint(ItemHint itemHint) {
        this.configuration.getHints().add(itemHint);
        this.hintsCache.put(itemHint.getName(), itemHint);
    }
}

