/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.config;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.junit.After;
import org.junit.Test;

public class MicroProfileConfigJavaHoverTest
extends BasePropertiesManagerTest {
    private static IJavaProject javaProject;

    @After
    public void cleanup() throws JavaModelException, IOException {
        MicroProfileConfigJavaHoverTest.deleteFile("application.yaml", javaProject);
        MicroProfileConfigJavaHoverTest.deleteFile("application.properties", javaProject);
        MicroProfileConfigJavaHoverTest.deleteFile("META-INF/microprofile-config.properties", javaProject);
    }

    @Test
    public void configPropertyNameHover() throws Exception {
        javaProject = MicroProfileConfigJavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/application.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("application.properties", "greeting.message = hello\r\ngreeting.name = quarkus\r\ngreeting.number = 100", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hello` *in* [application.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 28), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hello` *in* [application.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 43), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hello` *in* [application.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 27), javaFileUri, JDT_UTILS, null);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 44), javaFileUri, JDT_UTILS, null);
        MicroProfileForJavaAssert.assertJavaHover(new Position(17, 33), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.suffix = !` *in* [GreetingResource.java](" + javaFileUri + ")", 17, 28, 43));
        MicroProfileForJavaAssert.assertJavaHover(new Position(26, 33), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.number = 100` *in* [application.properties](" + propertiesFileUri + ")", 26, 28, 43));
        MicroProfileForJavaAssert.assertJavaHover(new Position(23, 33), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.missing` is not set", 23, 28, 44));
    }

    @Test
    public void configPropertyNameHoverWithProfiles() throws Exception {
        javaProject = MicroProfileConfigJavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/application.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("application.properties", "greeting.message = hello\r\n%dev.greeting.message = hello dev\r\n%prod.greeting.message = hello prod\r\nmy.greeting.message\r\n%dev.my.greeting.message", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`%dev.greeting.message = hello dev` *in* [application.properties](" + propertiesFileUri + ")  \n" + "`%prod.greeting.message = hello prod` *in* [application.properties](" + propertiesFileUri + ")  \n" + "`greeting.message = hello` *in* [application.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileConfigJavaHoverTest.saveFile("application.properties", "%dev.greeting.message = hello dev\r\n%prod.greeting.message = hello prod\r\nmy.greeting.message\r\n%dev.my.greeting.message", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`%dev.greeting.message = hello dev` *in* [application.properties](" + propertiesFileUri + ")  \n" + "`%prod.greeting.message = hello prod` *in* [application.properties](" + propertiesFileUri + ")  \n" + "`greeting.message` is not set", 14, 28, 44));
    }

    @Test
    public void configPropertyNameYaml() throws Exception {
        javaProject = MicroProfileConfigJavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile yamlFile = project.getFile((IPath)new Path("src/main/resources/application.yaml"));
        String yamlFileUri = MicroProfileForJavaAssert.fixURI(yamlFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/application.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("application.yaml", "greeting:\n  message: message from yaml\n  number: 2001", javaProject);
        MicroProfileConfigJavaHoverTest.saveFile("application.properties", "greeting.message = hello\r\ngreeting.name = quarkus\r\ngreeting.number = 100", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = message from yaml` *in* [application.yaml](" + yamlFileUri + ")", 14, 28, 44));
        MicroProfileForJavaAssert.assertJavaHover(new Position(26, 33), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.number = 2001` *in* [application.yaml](" + yamlFileUri + ")", 26, 28, 43));
        MicroProfileConfigJavaHoverTest.saveFile("application.yaml", "greeting:\n  message: message from yaml", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(26, 33), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.number = 100` *in* [application.properties](" + propertiesFileUri + ")", 26, 28, 43));
    }

    @Test
    public void configPropertyNameMethod() throws Exception {
        javaProject = MicroProfileConfigJavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingMethodResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/application.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("application.properties", "greeting.method.message = hello", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(22, 61), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.method.message = hello` *in* [application.properties](" + propertiesFileUri + ")", 22, 51, 74));
        MicroProfileForJavaAssert.assertJavaHover(new Position(27, 60), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.method.suffix = !` *in* [GreetingMethodResource.java](" + javaFileUri + ")", 27, 50, 72));
        MicroProfileForJavaAssert.assertJavaHover(new Position(32, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.method.name` is not set", 32, 48, 68));
    }

    @Test
    public void configPropertyNameConstructor() throws Exception {
        javaProject = MicroProfileConfigJavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingConstructorResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/application.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("application.properties", "greeting.constructor.message = hello", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(23, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.constructor.message = hello` *in* [application.properties](" + propertiesFileUri + ")", 23, 36, 64));
        MicroProfileForJavaAssert.assertJavaHover(new Position(24, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.constructor.suffix = !` *in* [GreetingConstructorResource.java](" + javaFileUri + ")", 24, 36, 63));
        MicroProfileForJavaAssert.assertJavaHover(new Position(25, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.constructor.name` is not set", 25, 36, 61));
    }

    @Test
    public void configPropertyNameRespectsPrecendence() throws Exception {
        javaProject = MicroProfileConfigJavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingConstructorResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/application.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.constructor.message = hello 1", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(23, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.constructor.message = hello 1` *in* META-INF/microprofile-config.properties", 23, 36, 64));
        MicroProfileConfigJavaHoverTest.saveFile("application.properties", "greeting.constructor.message = hello 2", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(23, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.constructor.message = hello 2` *in* [application.properties](" + propertiesFileUri + ")", 23, 36, 64));
        MicroProfileConfigJavaHoverTest.saveFile("application.yaml", "greeting:\n  constructor:\n    message: hello 3", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(23, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.constructor.message = hello 3` *in* application.yaml", 23, 36, 64));
    }
}

