/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum MicroProfilePropertiesScope {
    sources(1),
    dependencies(2);

    private final int value;
    public static final List<MicroProfilePropertiesScope> ONLY_SOURCES;
    public static final List<MicroProfilePropertiesScope> SOURCES_AND_DEPENDENCIES;

    static {
        ONLY_SOURCES = Collections.singletonList(sources);
        SOURCES_AND_DEPENDENCIES = Arrays.asList(sources, dependencies);
    }

    private MicroProfilePropertiesScope(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MicroProfilePropertiesScope forValue(int value) {
        MicroProfilePropertiesScope[] allValues = MicroProfilePropertiesScope.values();
        if (value < 1 || value > allValues.length) {
            throw new IllegalArgumentException("Illegal enum value: " + value);
        }
        return allValues[value - 1];
    }

    public static boolean isOnlySources(List<MicroProfilePropertiesScope> scopes) {
        return scopes != null && scopes.size() == 1 && scopes.get(0) == sources;
    }
}

