/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.lsp4mp.commons.ClasspathKind;

public class JDTMicroProfileUtils {
    private static final Logger LOGGER = Logger.getLogger(JDTMicroProfileUtils.class.getName());

    private JDTMicroProfileUtils() {
    }

    public static String getProjectURI(IJavaProject project) {
        return JDTMicroProfileUtils.getProjectURI(project.getProject());
    }

    public static String getProjectURI(IProject project) {
        return project.getLocation().toOSString();
    }

    public static ClasspathKind getClasspathKind(IResource resource, IJavaProject javaProject) {
        IClasspathEntry[] classpath;
        IPath exactPath;
        IPath path = exactPath = resource.getFullPath();
        int resourceType = resource.getType();
        if (resourceType != 2) {
            // empty if block
        }
        try {
            classpath = ((JavaProject)javaProject).getResolvedClasspath();
        }
        catch (JavaModelException javaModelException) {
            return ClasspathKind.NONE;
        }
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            IPath entryPath = entry.getPath();
            if (entryPath.equals((Object)exactPath)) {
                return JDTMicroProfileUtils.getClasspathKind(entry);
            }
            if (entryPath.isAbsolute() && entryPath.equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation().append(exactPath))) {
                return JDTMicroProfileUtils.getClasspathKind(entry);
            }
            if (entryPath.isPrefixOf(path)) {
                return JDTMicroProfileUtils.getClasspathKind(entry);
            }
            ++i;
        }
        return ClasspathKind.NONE;
    }

    public static boolean hasNature(IProject project, String natureId) {
        try {
            return project != null && project.hasNature(natureId);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static ClasspathKind getClasspathKind(IClasspathEntry entry) {
        return entry.isTest() ? ClasspathKind.TEST : ClasspathKind.SRC;
    }

    public static boolean isMicroProfileProject(IJavaProject javaProject) {
        try {
            return javaProject.findType("org.eclipse.microprofile.config.inject.ConfigProperty") != null;
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.INFO, "Current Java project is not a MicroProfile project", e);
            return false;
        }
    }
}

