/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.jaxrs;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.lsp4mp.jdt.core.java.codelens.JavaCodeLensContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsUtils;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class JaxRsContext {
    public static final int DEFAULT_PORT = 8080;
    private static final String CONTEXT_KEY = JaxRsContext.class.getName();
    private int serverPort;
    private String rootPath;
    private String applicationPath;
    private final JavaCodeLensContext javaCodeLensContext;

    public JaxRsContext(JavaCodeLensContext javaCodeLensContext) {
        this.setServerPort(8080);
        this.javaCodeLensContext = javaCodeLensContext;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getApplicationPath(IProgressMonitor monitor) throws CoreException {
        if (this.applicationPath == null) {
            IType applicationPathType = JDTTypeUtils.findType(this.javaCodeLensContext.getJavaProject(), "javax.ws.rs.ApplicationPath");
            this.applicationPath = JaxRsContext.findApplicationPath(applicationPathType, this.javaCodeLensContext, monitor);
        }
        return this.applicationPath;
    }

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = applicationPath;
    }

    public static JaxRsContext getJaxRsContext(JavaCodeLensContext context) {
        JaxRsContext jaxRsContext = (JaxRsContext)context.get(CONTEXT_KEY);
        if (jaxRsContext == null) {
            jaxRsContext = new JaxRsContext(context);
            context.put(CONTEXT_KEY, jaxRsContext);
        }
        return jaxRsContext;
    }

    public String getLocalBaseURL() {
        StringBuilder localBaseURL = new StringBuilder("http://localhost:");
        localBaseURL.append(this.getServerPort());
        if (this.rootPath != null) {
            localBaseURL.append(this.getRootPath());
        }
        if (this.applicationPath != null) {
            if (!this.applicationPath.startsWith("/")) {
                localBaseURL.append('/');
            }
            localBaseURL.append(this.applicationPath);
        }
        return localBaseURL.toString();
    }

    private static String findApplicationPath(IType annotationType, JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        final AtomicReference applicationPathRef = new AtomicReference();
        SearchPattern pattern = SearchPattern.createPattern((String)"javax.ws.rs.ApplicationPath", (int)8, (int)65536, (int)0);
        SearchEngine engine = new SearchEngine();
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, JaxRsContext.createSearchScope(annotationType.getJavaProject()), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object o = match.getElement();
                if (o instanceof IType) {
                    this.collectApplicationPath((IType)o);
                }
            }

            private void collectApplicationPath(IType type) throws CoreException {
                if (AnnotationUtils.hasAnnotation((IAnnotatable)type, "javax.ws.rs.ApplicationPath")) {
                    applicationPathRef.set(JaxRsUtils.getJaxRsApplicationPathValue((IAnnotatable)type));
                }
            }
        }, monitor);
        return (String)applicationPathRef.get();
    }

    private static IJavaSearchScope createSearchScope(IJavaProject javaProject) throws CoreException {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{javaProject}, (int)1);
    }
}

