/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.lsp4mp.jdt.core.AbstractPropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.SearchContext;

public abstract class AbstractTypeDeclarationPropertiesProvider
extends AbstractPropertiesProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractTypeDeclarationPropertiesProvider.class.getName());

    @Override
    protected String[] getPatterns() {
        return this.getTypeNames();
    }

    protected abstract String[] getTypeNames();

    @Override
    public void collectProperties(SearchMatch match, SearchContext context, IProgressMonitor monitor) {
        Object element = match.getElement();
        if (element instanceof IType) {
            String[] names;
            IType type = (IType)element;
            String className = type.getFullyQualifiedName();
            String[] stringArray = names = this.getTypeNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    String name = stringArray[n2];
                    if (name.equals(className)) {
                        try {
                            this.processClass(type, className, context, monitor);
                            break;
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                            LOGGER.log(Level.SEVERE, "Cannot compute MicroProfile properties for the Java class '" + className + "'.", e);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    protected abstract void processClass(IType var1, String var2, SearchContext var3, IProgressMonitor var4) throws JavaModelException;
}

